/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.economy.plugins;

import com.iCo6.iConomy;
import com.iCo6.system.Accounts;
import de.tobiyas.util.RaC.economy.plugins.AbstractMoneyPlugin;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class IconomyMoney
extends AbstractMoneyPlugin {
    private boolean isActive = this.initIcon();
    private Accounts accounts;

    @Override
    public double getMoneyOfPlayer(OfflinePlayer player) {
        if (!this.isActive) {
            return 0.0;
        }
        if (!this.accounts.exists(player.getName())) {
            return 0.0;
        }
        return this.accounts.get(player.getName()).getHoldings().getBalance();
    }

    @Override
    public boolean addMoney(OfflinePlayer player, double amount) {
        if (!this.isActive) {
            return false;
        }
        if (!this.accounts.exists(player.getName())) {
            return false;
        }
        this.accounts.get(player.getName()).getHoldings().add(amount);
        return true;
    }

    @Override
    public boolean transferMoney(OfflinePlayer from, OfflinePlayer to, double amount) {
        if (!this.isActive) {
            return false;
        }
        if (!this.accounts.exists(from.getName())) {
            return false;
        }
        if (!this.accounts.exists(to.getName())) {
            return false;
        }
        if (!this.accounts.get(from.getName()).getHoldings().hasEnough(amount)) {
            return false;
        }
        this.accounts.get(from.getName()).getHoldings().subtract(amount);
        this.accounts.get(to.getName()).getHoldings().add(amount);
        return true;
    }

    @Override
    public boolean removeMoney(OfflinePlayer player, double amount) {
        if (!this.isActive) {
            return false;
        }
        if (this.getMoneyOfPlayer(player) < amount) {
            return false;
        }
        this.accounts.get(player.getName()).getHoldings().subtract(amount);
        return false;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    private boolean initIcon() {
        try {
            iConomy tempPlugin = (iConomy)Bukkit.getPluginManager().getPlugin("iConomy");
            if (tempPlugin == null) {
                return false;
            }
            if (!tempPlugin.isEnabled()) {
                return false;
            }
            this.accounts = new Accounts();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "iConomy6";
    }

    @Override
    public void createBankAccount(String name, OfflinePlayer owner) {
    }

    @Override
    public void removeBankAccount(String name) {
    }

    @Override
    public boolean addToBankAccount(String name, double amount) {
        return false;
    }

    @Override
    public boolean withdrawFromBankAccount(String name, double amount) {
        return false;
    }

    @Override
    public double getBankBalance(String bankName) {
        return 0.0;
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }
}

