/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.economy.plugins;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.api.Economy;
import com.earth2me.essentials.api.UserDoesNotExistException;
import de.tobiyas.util.RaC.economy.plugins.AbstractMoneyPlugin;
import java.math.BigDecimal;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class EssentialsEcoMoney
extends AbstractMoneyPlugin {
    boolean isActive = this.initEssentials();

    @Override
    public double getMoneyOfPlayer(OfflinePlayer player) {
        try {
            return Economy.getMoneyExact((String)player.getName()).doubleValue();
        }
        catch (UserDoesNotExistException e) {
            return Double.MIN_VALUE;
        }
    }

    @Override
    public boolean addMoney(OfflinePlayer player, double amount) {
        if (!Economy.playerExists((String)player.getName())) {
            return false;
        }
        try {
            Economy.add((String)player.getName(), (BigDecimal)new BigDecimal(amount));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean transferMoney(OfflinePlayer from, OfflinePlayer to, double amount) {
        if (this.getMoneyOfPlayer(from) < amount) {
            return false;
        }
        if (this.getMoneyOfPlayer(to) != Double.MIN_VALUE) {
            return false;
        }
        try {
            if (!Economy.hasEnough((String)from.getName(), (BigDecimal)new BigDecimal(amount))) {
                return false;
            }
        }
        catch (UserDoesNotExistException e) {
            return false;
        }
        this.removeMoney(from, amount);
        this.addMoney(to, amount);
        return true;
    }

    @Override
    public boolean removeMoney(OfflinePlayer player, double amount) {
        if (!Economy.playerExists((String)player.getName())) {
            return false;
        }
        try {
            if (!Economy.hasEnough((String)player.getName(), (BigDecimal)new BigDecimal(amount))) {
                return false;
            }
        }
        catch (UserDoesNotExistException e) {
            return false;
        }
        try {
            Economy.substract((String)player.getName(), (BigDecimal)new BigDecimal(amount));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    private boolean initEssentials() {
        try {
            Essentials tempPlugin = (Essentials)Bukkit.getPluginManager().getPlugin("Essentials");
            if (tempPlugin == null) {
                return false;
            }
            if (!tempPlugin.isEnabled()) {
                return false;
            }
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "EssentialsECO";
    }

    @Override
    public void createBankAccount(String name, OfflinePlayer owner) {
    }

    @Override
    public void removeBankAccount(String name) {
    }

    @Override
    public boolean addToBankAccount(String name, double amount) {
        return false;
    }

    @Override
    public boolean withdrawFromBankAccount(String name, double amount) {
        return false;
    }

    @Override
    public double getBankBalance(String bankName) {
        return 0.0;
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }
}

