/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.economy.defaults.banks;

import de.tobiyas.util.RaC.economy.defaults.banks.BankAccount;
import de.tobiyas.util.RaC.economy.defaults.banks.BankStore;
import java.io.File;
import java.util.List;
import org.bukkit.plugin.java.JavaPlugin;

public class STDBank {
    private List<BankAccount> accounts;

    public STDBank(JavaPlugin plugin) {
        this.accounts = BankStore.loadBanks(plugin.getDataFolder().toString() + File.separator + "accounts.yml");
    }

    public void saveBanks() {
        BankStore.saveBanks(this.accounts);
    }

    public void createBankAccount(String name) {
        BankAccount account = this.findAccount(name);
        if (account != null) {
            return;
        }
        this.accounts.add(new BankAccount(name));
    }

    public void removeBankAccount(String name) {
        BankAccount account = this.findAccount(name);
        if (account != null) {
            return;
        }
        this.accounts.remove(account);
    }

    public void addToBankAccount(String name, double amount) {
        BankAccount account = this.findAccount(name);
        if (account == null) {
            return;
        }
        account.increaseBalance(amount);
    }

    public boolean withdrawFromBankAccount(String name, double amount) {
        BankAccount account = this.findAccount(name);
        if (account == null) {
            return false;
        }
        if (account.getBalance() < amount) {
            return false;
        }
        account.reduceBalance(amount);
        return true;
    }

    public double getBankBalance(String bankName) {
        BankAccount account = this.findAccount(bankName);
        if (account == null) {
            return 0.0;
        }
        return account.getBalance();
    }

    private BankAccount findAccount(String name) {
        for (BankAccount account : this.accounts) {
            if (!account.getName().equalsIgnoreCase(name)) continue;
            return account;
        }
        return null;
    }
}

