/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.economy;

import de.tobiyas.util.RaC.economy.plugins.AbstractMoneyPlugin;
import de.tobiyas.util.RaC.economy.plugins.EssentialsEcoMoney;
import de.tobiyas.util.RaC.economy.plugins.IconomyMoney;
import de.tobiyas.util.RaC.economy.plugins.MoneyPlugin;
import de.tobiyas.util.RaC.economy.plugins.OwnCurrencyPlugin;
import de.tobiyas.util.RaC.economy.plugins.VaultMoney;
import java.util.logging.Level;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.java.JavaPlugin;

public class MoneyManager
extends AbstractMoneyPlugin {
    private JavaPlugin plugin;
    private MoneyPlugin moneyPlugin;
    private boolean isActive;

    public MoneyManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.isActive = this.initMoneyPlugin();
        if (!this.isActive) {
            plugin.getLogger().log(Level.WARNING, "No Economy System found.");
        }
    }

    private boolean initMoneyPlugin() {
        AbstractMoneyPlugin tempPlugin = new OwnCurrencyPlugin();
        if (tempPlugin.isActive()) {
            this.moneyPlugin = tempPlugin;
            return true;
        }
        tempPlugin = new VaultMoney();
        if (tempPlugin.isActive()) {
            this.moneyPlugin = tempPlugin;
            return true;
        }
        tempPlugin = new IconomyMoney();
        if (tempPlugin.isActive()) {
            this.moneyPlugin = tempPlugin;
            return true;
        }
        try {
            tempPlugin = new EssentialsEcoMoney();
            if (tempPlugin.isActive()) {
                this.moneyPlugin = tempPlugin;
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return false;
    }

    public boolean transferPlayerToBank(OfflinePlayer player, String bankName, double amount) {
        if (!this.isActive) {
            return false;
        }
        double playerAmount = this.moneyPlugin.getMoneyOfPlayer(player);
        if (playerAmount < amount) {
            return false;
        }
        this.moneyPlugin.removeMoney(player, amount);
        this.moneyPlugin.addToBankAccount(bankName, amount);
        return true;
    }

    public boolean transferBankToPlayer(OfflinePlayer player, String bankName, double amount) {
        if (!this.isActive) {
            return false;
        }
        double bankAmount = this.moneyPlugin.getBankBalance(bankName);
        if (bankAmount < amount) {
            return false;
        }
        this.moneyPlugin.withdrawFromBankAccount(bankName, amount);
        this.moneyPlugin.addMoney(player, amount);
        return true;
    }

    public String getActiveEcoName() {
        if (!this.isActive) {
            return "NONE";
        }
        return this.moneyPlugin.getName();
    }

    @Override
    public void createBankAccount(String clanName, OfflinePlayer owner) {
        if (!this.isActive) {
            return;
        }
        this.moneyPlugin.createBankAccount(clanName, owner);
    }

    @Override
    public double getBankBalance(String clanName) {
        if (!this.isActive) {
            return 0.0;
        }
        return this.moneyPlugin.getBankBalance(clanName);
    }

    @Override
    public void removeBankAccount(String clanName) {
        if (!this.isActive) {
            return;
        }
        this.moneyPlugin.removeBankAccount(clanName);
    }

    @Override
    public boolean addToBankAccount(String clanName, double amount) {
        if (!this.isActive) {
            return false;
        }
        return this.moneyPlugin.addToBankAccount(clanName, amount);
    }

    @Override
    public boolean withdrawFromBankAccount(String clanName, double amount) {
        if (!this.isActive) {
            return false;
        }
        return this.moneyPlugin.withdrawFromBankAccount(clanName, amount);
    }

    @Override
    public boolean addMoney(OfflinePlayer player, double amount) {
        if (!this.isActive) {
            return false;
        }
        if (this.moneyPlugin.getMoneyOfPlayer(player) == Double.MIN_VALUE) {
            return false;
        }
        return this.moneyPlugin.addMoney(player, amount);
    }

    @Override
    public boolean removeMoney(OfflinePlayer player, double amount) {
        if (!this.isActive) {
            return false;
        }
        if (this.moneyPlugin.getMoneyOfPlayer(player) < amount) {
            return false;
        }
        if (this.moneyPlugin.getMoneyOfPlayer(player) == Double.MIN_VALUE) {
            return false;
        }
        this.moneyPlugin.removeMoney(player, amount);
        return true;
    }

    @Override
    public double getMoneyOfPlayer(OfflinePlayer player) {
        if (!this.isActive) {
            return 0.0;
        }
        return this.moneyPlugin.getMoneyOfPlayer(player);
    }

    @Override
    public boolean isActive() {
        return this.moneyPlugin.isActive();
    }

    @Override
    public boolean transferMoney(OfflinePlayer from, OfflinePlayer to, double amount) {
        if (!this.isActive) {
            return false;
        }
        return this.moneyPlugin.transferMoney(from, to, amount);
    }

    @Override
    public boolean hasBankSupport() {
        if (!this.isActive) {
            return false;
        }
        return this.moneyPlugin.hasBankSupport();
    }

    @Override
    public String getName() {
        if (!this.isActive) {
            return "NONE";
        }
        return this.moneyPlugin.getName();
    }
}

