/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.debug.logger;

import de.tobiyas.util.RaC.UtilsUsingPlugin;
import de.tobiyas.util.RaC.debug.erroruploader.ErrorUploader;
import de.tobiyas.util.RaC.debug.logger.ConsoleLogFormatter;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;

public class DebugLogger {
    private final int MAX_DAYS_KEEP_BACKUP = 10;
    private UtilsUsingPlugin plugin;
    private Logger debugLogger;
    private Logger errorLogger;
    private ErrorUploader errorUploader;
    private FileHandler debugFileHandler;
    private FileHandler errorFileHandler;
    private File debugSaveFile;
    private File errorSaveFile;
    private boolean enabled;
    private boolean enableUploads;
    private boolean alsoOutputToDefaultLogger;

    public DebugLogger(UtilsUsingPlugin plugin) {
        this.plugin = plugin;
        this.alsoOutputToDefaultLogger = false;
        this.enabled = true;
        this.enableUploads = false;
        this.createStructur();
        this.initLoggers();
        this.errorUploader = new ErrorUploader((Plugin)plugin, this.errorLogger);
    }

    private void createStructur() {
        String path = this.plugin.getDataFolder() + File.separator + "Debug" + File.separator;
        File pathFile = new File(path);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        String debugFileName = "debug.log";
        this.debugSaveFile = new File(pathFile, debugFileName);
        SimpleDateFormat df = new SimpleDateFormat("MM_dd_yyyy");
        Date today = Calendar.getInstance().getTime();
        String reportDate = df.format(today);
        File baseBackupDir = new File(pathFile, "Backup");
        File backupDir = new File(baseBackupDir, "Backup - " + reportDate);
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        if (baseBackupDir.listFiles() != null) {
            SimpleDateFormat format = new SimpleDateFormat("MM_dd_yyyy");
            long now = System.currentTimeMillis();
            for (File backupDateDir : baseBackupDir.listFiles()) {
                String fileName = backupDateDir.getName();
                fileName = fileName.substring(9);
                try {
                    Date date = format.parse(fileName);
                    long diff = now - date.getTime();
                    int days = (int)(diff / 86400000L);
                    if (days <= 10) continue;
                    this.deleteFolder(backupDateDir);
                }
                catch (Throwable exp) {
                    exp.printStackTrace();
                }
            }
        }
        if (this.debugSaveFile.exists()) {
            SimpleDateFormat df2 = new SimpleDateFormat("HH_mm_ss");
            String fileName = df2.format(today);
            File backupFile = new File(backupDir, fileName + "_debug.log");
            this.debugSaveFile.renameTo(backupFile);
            this.debugSaveFile.delete();
        }
        if (!this.debugSaveFile.exists()) {
            try {
                this.debugSaveFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, ChatColor.YELLOW + "[" + this.plugin.getName() + "] Debug File could not be created!");
            }
        }
        if (!(pathFile = new File(path = this.plugin.getDataFolder() + File.separator + "Debug" + File.separator)).exists()) {
            pathFile.mkdirs();
        }
        String errorFileName = "error.log";
        this.errorSaveFile = new File(pathFile, errorFileName);
        if (this.errorSaveFile.exists()) {
            SimpleDateFormat df2 = new SimpleDateFormat("HH_mm_ss");
            String fileName = df2.format(today);
            File backupFile = new File(backupDir, fileName + "error.log");
            this.errorSaveFile.renameTo(backupFile);
            this.errorSaveFile.delete();
        }
        if (!this.errorSaveFile.exists()) {
            try {
                this.errorSaveFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, ChatColor.YELLOW + "[" + this.plugin.getName() + "] Debug File could not be created!");
            }
        }
    }

    private void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    private void initLoggers() {
        this.initDebugLogger();
        this.initErrorLogger();
    }

    private void initDebugLogger() {
        this.debugLogger = Logger.getLogger("minecraft." + this.plugin.getName() + ".debug");
        this.debugLogger.setUseParentHandlers(this.alsoOutputToDefaultLogger);
        try {
            this.debugFileHandler = new FileHandler(this.debugSaveFile.toString(), true);
            this.debugLogger.addHandler(this.debugFileHandler);
            this.debugLogger.setLevel(Level.ALL);
            this.debugFileHandler.setFormatter(new ConsoleLogFormatter(true));
            this.log("Debugger for Plugin:" + this.plugin.getName() + " Version: " + this.plugin.getDescription().getVersion() + " Started! System-Time: " + Calendar.getInstance().getTime().toString());
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initErrorLogger() {
        this.errorLogger = Logger.getLogger("minecraft." + this.plugin.getName() + ".debug.error");
        this.errorLogger.setUseParentHandlers(false);
        try {
            this.errorFileHandler = new FileHandler(this.errorSaveFile.toString(), true);
            this.errorLogger.addHandler(this.errorFileHandler);
            this.errorLogger.setLevel(Level.ALL);
            this.errorFileHandler.setFormatter(new ConsoleLogFormatter(true));
            this.errorLogger.log(Level.INFO, "Debugger for Plugin: " + this.plugin.getName() + " Version: " + this.plugin.getDescription().getVersion() + " Started! System-Time: " + Calendar.getInstance().getTime().toString());
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void log(String msg) {
        String pluginPrefix = "[" + this.plugin.getDescription().getName() + "]";
        this.debugLogger.log(Level.INFO, pluginPrefix + msg);
    }

    public void logWarning(String msg) {
        if (this.enabled) {
            String pluginPrefix = "[" + this.plugin.getDescription().getName() + "]";
            this.debugLogger.log(Level.WARNING, pluginPrefix + msg);
        }
    }

    public void logError(String msg) {
        this.logError(msg, true);
    }

    public void logDebug(String message) {
        if (this.enabled) {
            String pluginPrefix = "[" + this.plugin.getDescription().getName() + "]";
            this.debugLogger.log(Level.INFO, pluginPrefix + message);
        }
    }

    private void logError(String msg, boolean logToErrorlogger) {
        String pluginPrefix = "[" + this.plugin.getDescription().getName() + "]";
        if (this.enabled) {
            this.debugLogger.log(Level.SEVERE, pluginPrefix + msg);
        }
        if (logToErrorlogger) {
            this.errorLogger.log(Level.SEVERE, pluginPrefix + msg);
        }
    }

    public void setAlsoToPlugin(boolean value) {
        this.alsoOutputToDefaultLogger = value;
        if (this.debugLogger == null) {
            return;
        }
        this.debugLogger.setUseParentHandlers(value);
    }

    public void shutDown() {
        this.debugLogger.removeHandler(this.debugFileHandler);
        this.debugFileHandler.close();
        this.errorLogger.removeHandler(this.errorFileHandler);
        this.errorFileHandler.close();
    }

    public void restart() {
        this.createStructur();
        this.initLoggers();
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    public void enableUploads(boolean enable) {
        this.enableUploads = enable;
    }

    public void logStackTrace(Throwable error) {
        this.logError("Stacktrace in error.log!", false);
        this.errorLogger.log(Level.SEVERE, "Critical Error", error);
        if (this.enableUploads) {
            this.errorUploader.uploadStacktrace(error);
        }
    }

    public void logStackTrace(String message, Throwable error) {
        this.logError("Stacktrace in error.log!", false);
        this.errorLogger.log(Level.SEVERE, message, error);
        if (this.enableUploads) {
            this.errorUploader.uploadStacktrace(error);
        }
    }
}

