/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.debug.erroruploader;

import de.tobiyas.util.RaC.config.UtilConsts;
import de.tobiyas.util.RaC.debug.erroruploader.ErrorUploaderResponceCode;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;

public class BuildPackage
extends Thread {
    private static final String sendAdress = "http://tobiyas.tk/upload.php";
    private String pluginVersion;
    private String pluginName;
    private String utilsVersion;
    private String utilsState;
    private Throwable error;
    private Logger logger;

    public BuildPackage(String pluginVersion, String pluginName, Throwable error, Logger logger) {
        this.pluginVersion = pluginVersion;
        this.pluginName = pluginName;
        this.utilsVersion = UtilConsts.utilsBuildVersion;
        this.utilsState = UtilConsts.utilsBuildState;
        this.logger = logger;
        this.error = error;
    }

    private String encodePackage() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append(this.convertValue("serverName", Bukkit.getServer().getServerName())).append("&");
            builder.append(this.convertValue("bukkitBuild", Bukkit.getServer().getVersion())).append("&");
            builder.append(this.convertValue("pluginVersion", this.pluginVersion)).append("&");
            builder.append(this.convertValue("pluginName", this.pluginName)).append("&");
            builder.append(this.convertValue("utilsVersion", this.utilsVersion + " " + this.utilsState)).append("&");
            builder.append(this.convertValue("errorClass", this.error.getClass().getName())).append("&");
            builder.append(this.convertValue("errorMessage", this.error.getLocalizedMessage())).append("&");
            StackTraceElement[] trace = this.error.getStackTrace();
            String traceString = "";
            for (StackTraceElement element : trace) {
                traceString = traceString + element.toString() + "\n";
            }
            builder.append(this.convertValue("stacktrace", traceString));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return builder.toString();
    }

    private String convertValue(String key, String value) throws UnsupportedEncodingException {
        String temp = URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
        return temp;
    }

    @Override
    public void run() {
        this.sendError();
        this.interrupt();
    }

    private void sendError() {
        try {
            URL url = new URL(sendAdress);
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(this.encodePackage());
            writer.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String response = reader.readLine();
            writer.close();
            reader.close();
            this.logger.log(Level.INFO, "Responce Code: " + response + " " + ErrorUploaderResponceCode.getMessageToError(response));
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error while uploading log: " + e.getLocalizedMessage().toString());
            e.printStackTrace();
        }
    }
}

