/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.config.returncontainer;

import java.util.Random;
import org.bukkit.inventory.ItemStack;

public class DropContainer {
    private ItemStack item;
    private int max;
    private int min;
    private double probability;

    public DropContainer(ItemStack item, int min, int max, double probability) {
        this.item = item;
        this.min = min;
        this.max = max;
        this.probability = probability;
    }

    public DropContainer(int itemId, int min, int max, double probability) {
        this.item = new ItemStack(itemId);
        this.min = min;
        this.max = max;
        this.probability = probability;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public double getProbability() {
        return this.probability;
    }

    public ItemStack generateItem() {
        int amount = this.min + this.calcAbs();
        ItemStack stack = this.item.clone();
        stack.setAmount(amount);
        return this.item;
    }

    private int calcAbs() {
        Random rand = new Random();
        int total = 0;
        int abs = this.max - this.min;
        for (int i = 0; i < abs; ++i) {
            if (!(rand.nextDouble() < this.probability)) continue;
            ++total;
        }
        return total;
    }
}

