/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.config.pluginconfig;

import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import de.tobiyas.util.RaC.config.pluginconfig.ConfigField;
import de.tobiyas.util.RaC.config.pluginconfig.ConfigurationFailedException;
import de.tobiyas.util.RaC.config.pluginconfig.PluginConfig;
import java.io.File;
import java.lang.reflect.Field;

public class PluginConfigParser {
    public static void fillConfig(PluginConfig config, File file) throws ConfigurationFailedException {
        Field[] fields;
        YAMLConfigExtended ymlConfig = new YAMLConfigExtended(file).load();
        if (!ymlConfig.getValidLoad()) {
            throw new ConfigurationFailedException("Could not load Config File.");
        }
        for (Field field : fields = config.getClass().getFields()) {
            try {
                field.setAccessible(true);
                ConfigField configField = field.getAnnotation(ConfigField.class);
                if (configField == null) continue;
                Class<?> fieldClass = field.get(config).getClass();
                Object value = ymlConfig.get(configField.path(), configField.defaultValueAsString());
                value = PluginConfigParser.modifyToCorrectValue(fieldClass, value);
                field.set(config, value);
            }
            catch (SecurityException exp) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    private static Object modifyToCorrectValue(Class<?> fieldClass, Object value) {
        return null;
    }
}

