/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.config;

import de.tobiyas.util.RaC.UtilsUsingPlugin;
import de.tobiyas.util.RaC.config.returncontainer.DropContainer;
import de.tobiyas.util.RaC.formating.ParseUtils;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;

public class YAMLConfigExtended
extends YamlConfiguration {
    private static final String PATH_SPLIT_PATTERN = Pattern.quote(".");
    private boolean dirty = false;
    private String savePath;
    private String totalPath;
    private boolean validLoad;
    private int autoReloadableSchedulerID = -1;
    private Throwable lastParseException = null;
    private Date lastChangeDate = null;

    public YAMLConfigExtended() {
    }

    public YAMLConfigExtended(File file) {
        this.validLoad = false;
        this.savePath = file.getParent();
        this.totalPath = file.getPath();
    }

    public YAMLConfigExtended(String savePath, String fileName) {
        this.validLoad = false;
        this.savePath = savePath;
        this.totalPath = savePath + File.separator + fileName;
    }

    public YAMLConfigExtended(String savePath) {
        this.validLoad = false;
        File tempFile = new File(savePath);
        this.savePath = tempFile.getParent();
        this.totalPath = savePath;
    }

    public Set<String> getChildren(String yamlNode) {
        try {
            ConfigurationSection tempMem = this.getConfigurationSection(yamlNode);
            Set tempSet = tempMem.getKeys(false);
            return tempSet;
        }
        catch (Exception e) {
            return new LinkedHashSet<String>();
        }
    }

    public Set<String> getRootChildren() {
        try {
            Configuration tempMem = this.getRoot();
            Set tempSet = tempMem.getKeys(false);
            return tempSet;
        }
        catch (Exception e) {
            LinkedHashSet<String> empty = new LinkedHashSet<String>();
            return empty;
        }
    }

    public boolean save() {
        if (!this.dirty) {
            return true;
        }
        if (this.totalPath == null) {
            return true;
        }
        File file = this.fileCheck();
        try {
            this.save(file);
            this.dirty = false;
            this.lastChangeDate = new Date(file.lastModified());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void forceSave() {
        if (this.totalPath == null) {
            return;
        }
        File file = this.fileCheck();
        try {
            this.save(file);
            this.dirty = false;
            this.lastChangeDate = new Date(file.lastModified());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveAsync() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    YAMLConfigExtended.this.save();
                    YAMLConfigExtended.this.dirty = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        try {
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                if (!plugin.isEnabled()) continue;
                Bukkit.getScheduler().runTaskAsynchronously(plugin, runnable);
                return;
            }
            throw new IllegalPluginAccessException();
        }
        catch (IllegalPluginAccessException exp) {
            new Thread(Thread.currentThread().getThreadGroup(), runnable, "ConfigSavingThread").start();
            return;
        }
    }

    public YAMLConfigExtended load() {
        File saveFile;
        File savePathFile = new File(this.totalPath);
        if (!savePathFile.exists()) {
            try {
                savePathFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((saveFile = this.fileCheck()) == null) {
            this.validLoad = false;
            return this;
        }
        try {
            this.load(saveFile);
            if (this.isBoolean("utf8") && this.getBoolean("utf8")) {
                return this.loadCharset(saveFile, "UTF-8");
            }
            if (this.isBoolean("ansi") && this.getBoolean("ansi")) {
                return this.loadCharset(saveFile, "windows-1252");
            }
            this.lastChangeDate = new Date(savePathFile.lastModified());
            this.lastParseException = null;
        }
        catch (Exception e) {
            this.validLoad = false;
            this.lastParseException = e;
            System.out.println("Error on loading YamlConfig: " + saveFile.getAbsolutePath() + ", error: " + e.getMessage());
            return this;
        }
        this.validLoad = true;
        this.dirty = false;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YAMLConfigExtended loadCharset(File file, String charset) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName(charset));
            StringBuilder builder = new StringBuilder();
            BufferedReader input = new BufferedReader(reader);
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    builder.append(line);
                    builder.append('\n');
                }
            }
            finally {
                input.close();
            }
            this.loadFromString(builder.toString());
            this.validLoad = true;
        }
        catch (Throwable e) {
            try {
                this.load(file);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this;
        }
        return this;
    }

    public boolean getValidLoad() {
        return this.validLoad;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private File fileCheck() {
        File fileFile = new File(this.totalPath);
        if (!fileFile.exists()) {
            File saveDir = new File(this.savePath);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            try {
                fileFile.createNewFile();
            }
            catch (IOException e) {
                return null;
            }
        }
        return fileFile;
    }

    public void set(String path, Object object) {
        List list;
        if (object != null && object.equals(this.get(path))) {
            return;
        }
        this.dirty = true;
        if (object instanceof Location) {
            this.setLocation(path, (Location)object);
            return;
        }
        if (object instanceof Material) {
            this.setMaterial(path, (Material)object);
            return;
        }
        if (object instanceof DropContainer) {
            this.setDropContainer(path, (DropContainer)object);
            return;
        }
        if (object instanceof ItemStack) {
            this.setItemStack(path, (ItemStack)object);
            return;
        }
        if (object instanceof String) {
            super.set(path, (Object)YAMLConfigExtended.replaceUmlautsBack((String)object));
            return;
        }
        if (object instanceof List && !(list = (List)object).isEmpty() && list.get(0) instanceof String) {
            LinkedList<String> copy = new LinkedList<String>();
            for (Object value : list) {
                if (!(value instanceof String)) continue;
                copy.add(YAMLConfigExtended.replaceUmlautsBack((String)value));
            }
            super.set(path, copy);
            return;
        }
        super.set(path, object);
    }

    public String getString(String path) {
        String result = super.getString(path);
        return YAMLConfigExtended.replaceUmlauts(result);
    }

    public String getString(String path, String def) {
        String result = super.getString(path, def);
        return YAMLConfigExtended.replaceUmlauts(result);
    }

    public List<String> getStringList(String path) {
        LinkedList<String> newStringList = new LinkedList<String>();
        if (this.isString(path)) {
            return new ArrayList<String>(Arrays.asList(this.getString(path)));
        }
        List stringList = super.getStringList(path);
        for (String string : stringList) {
            string = YAMLConfigExtended.replaceUmlauts(string);
            newStringList.add(string);
        }
        return newStringList;
    }

    public static String replaceUmlauts(String toReplace) {
        if (toReplace == null) {
            return null;
        }
        toReplace = toReplace.replace("<o>", "\u00f6");
        toReplace = toReplace.replace("<O>", "\u00d6");
        toReplace = toReplace.replace("<a>", "\u00e4");
        toReplace = toReplace.replace("<A>", "\u00c4");
        toReplace = toReplace.replace("<u>", "\u00fc");
        toReplace = toReplace.replace("<U>", "\u00dc");
        toReplace = toReplace.replace("<ss>", "\u00df");
        return toReplace;
    }

    public static String replaceUmlautsBack(String toReplace) {
        if (toReplace == null) {
            return null;
        }
        toReplace = toReplace.replace("\u00f6", "<o>");
        toReplace = toReplace.replace("\u00d6", "<O>");
        toReplace = toReplace.replace("\u00e4", "<a>");
        toReplace = toReplace.replace("\u00c4", "<A>");
        toReplace = toReplace.replace("\u00fc", "<u>");
        toReplace = toReplace.replace("\u00dc", "<U>");
        toReplace = toReplace.replace("\u00df", "<ss>");
        return toReplace;
    }

    public void setLocation(String path, Location location) {
        if (location == null) {
            this.set(path, null);
            return;
        }
        double locX = location.getX();
        double locY = location.getY();
        double locZ = location.getZ();
        double pitch = location.getPitch();
        double yaw = location.getYaw();
        String world = location.getWorld().getName();
        this.createSection(path);
        this.set(path + ".x", locX);
        this.set(path + ".y", locY);
        this.set(path + ".z", locZ);
        this.set(path + ".pitch", pitch);
        this.set(path + ".yaw", yaw);
        this.set(path + ".world", world);
    }

    public Location getLocation(String path, Location defaultLocation) {
        String toParse;
        if (this.isString(path) && (toParse = this.getString(path, null)) != null) {
            boolean hasWorld;
            String[] split = toParse.split(Pattern.quote("#"));
            if (split.length < 3) {
                return defaultLocation;
            }
            World world = Bukkit.getWorld((String)split[0]);
            boolean bl = hasWorld = world != null;
            if (world == null) {
                world = (World)Bukkit.getWorlds().get(0);
            }
            double x = ParseUtils.parseDouble(split, hasWorld ? 1 : 0, Double.MIN_VALUE);
            double y = ParseUtils.parseDouble(split, hasWorld ? 2 : 1, Double.MIN_VALUE);
            double z = ParseUtils.parseDouble(split, hasWorld ? 3 : 2, Double.MIN_VALUE);
            float yaw = ParseUtils.parseFloat(split, hasWorld ? 4 : 3, 0.0f);
            float pitch = ParseUtils.parseFloat(split, hasWorld ? 5 : 4, 0.0f);
            if (x == Double.MIN_VALUE || y == Double.MIN_VALUE || z == Double.MIN_VALUE) {
                return defaultLocation;
            }
            return new Location(world, x, y, z, yaw, pitch);
        }
        double locX = this.getDouble(path + ".x");
        double locY = this.getDouble(path + ".y");
        double locZ = this.getDouble(path + ".z");
        float yaw = (float)this.getDouble(path + ".yaw");
        float pitch = (float)this.getDouble(path + ".pitch");
        String world = this.getString(path + ".world");
        if (world == null) {
            return defaultLocation;
        }
        World World2 = Bukkit.getWorld((String)world);
        if (World2 == null) {
            return defaultLocation;
        }
        Location loc = new Location(World2, locX, locY, locZ, yaw, pitch);
        return loc;
    }

    public Location getLocation(String path) {
        return this.getLocation(path, null);
    }

    public void setDropContainer(String path, int itemID, int damageValue, int minAmount, int maxAmount, double probability) {
        DropContainer container = new DropContainer(itemID, minAmount, maxAmount, probability);
        this.setDropContainer(path, container);
    }

    public void setDropContainer(String path, DropContainer container) {
        if (container == null) {
            this.set(path, null);
            return;
        }
        this.createSection(path);
        this.set(path + ".item", container.getItem());
        this.set(path + ".min", container.getMin());
        this.set(path + ".max", container.getMax());
        this.set(path + ".probability", container.getProbability());
    }

    public DropContainer getDropContainer(String path) {
        ItemStack item = this.getItemStack(path + ".item", new ItemStack(Material.AIR));
        int minAmount = this.getInt(path + ".min", 0);
        int maxAmount = this.getInt(path + ".max", 0);
        double probability = this.getDouble(path + ".probability", 0.0);
        return new DropContainer(item, minAmount, maxAmount, probability);
    }

    public void setMaterial(String path, Material material) {
        if (material == null) {
            this.set(path, null);
            return;
        }
        this.set(path, material.name());
    }

    public Material getMaterial(String path, Material defaultMaterial) {
        if (this.isInt(path)) {
            try {
                return Material.getMaterial((int)this.getInt(path, -1));
            }
            catch (IllegalArgumentException exp) {
                return defaultMaterial;
            }
        }
        if (this.isString(path)) {
            try {
                Material mat = Material.matchMaterial((String)this.getString(path, ""));
                return mat == null ? defaultMaterial : mat;
            }
            catch (IllegalArgumentException exp) {
                return defaultMaterial;
            }
        }
        return defaultMaterial;
    }

    public void setItemStack(String pre, ItemStack item) {
        if (item == null) {
            this.set(pre, null);
            return;
        }
        this.createSection(pre + ".data");
        for (Map.Entry entry : item.serialize().entrySet()) {
            this.set(pre + ".data." + (String)entry.getKey(), entry.getValue());
        }
    }

    public ItemStack getItemStack(String pre, ItemStack defaultStack) {
        try {
            HashMap<String, Object> serialized = new HashMap<String, Object>();
            for (String data : this.getChildren(pre + ".data")) {
                Object obj = this.get(pre + ".data." + data);
                if (obj instanceof String) {
                    obj = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)obj));
                }
                serialized.put(data, obj);
            }
            ItemStack item = ItemStack.deserialize(serialized);
            if (item.hasItemMeta()) {
                ItemMeta meta = item.getItemMeta();
                if (meta.hasDisplayName()) {
                    meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)meta.getDisplayName()));
                }
                if (meta.hasLore()) {
                    List lore = meta.getLore();
                    for (int i = 0; i < lore.size(); ++i) {
                        lore.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)((String)lore.get(i))));
                    }
                    meta.setLore(lore);
                }
                item.setItemMeta(meta);
            }
            return item;
        }
        catch (Exception exp) {
            return defaultStack;
        }
    }

    public YAMLConfigExtended loadSafeFromString(String contents) {
        try {
            super.loadFromString(contents);
            this.dirty = false;
        }
        catch (Exception exp) {
            this.validLoad = false;
        }
        return this;
    }

    public File getFileLoadFrom() {
        if (this.totalPath == null) {
            return null;
        }
        return new File(this.totalPath);
    }

    public void setAutoReloadable(boolean autoReloadable, UtilsUsingPlugin plugin) {
        if (this.autoReloadableSchedulerID != -1) {
            Bukkit.getScheduler().cancelTask(this.autoReloadableSchedulerID);
            this.autoReloadableSchedulerID = -1;
        }
        if (autoReloadable) {
            new DebugBukkitRunnable("YMLConfigAutoReloader"){

                @Override
                protected void runIntern() {
                    Date lastChangeDate;
                    File savePathFile = new File(YAMLConfigExtended.this.totalPath);
                    if (savePathFile.exists() && (lastChangeDate = new Date(savePathFile.lastModified())).after(YAMLConfigExtended.this.lastChangeDate)) {
                        YAMLConfigExtended.this.load();
                    }
                }
            }.runTaskTimerAsynchronously((Plugin)plugin, 100L, 100L);
        }
    }

    public Object get(String path) {
        return super.get(YAMLConfigExtended.replaceUmlauts(path));
    }

    public Object get(String path, Object def) {
        return super.get(YAMLConfigExtended.replaceUmlauts(path), def);
    }

    public boolean isAutoReloadable() {
        return this.autoReloadableSchedulerID != -1;
    }

    public void clearConfig() {
        this.map.clear();
        this.dirty = true;
    }

    public Throwable getLastParseException() {
        return this.lastParseException;
    }

    public static String getLastPartOfPath(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        String[] split = path.split(PATH_SPLIT_PATTERN);
        return split[split.length - 1];
    }
}

