/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.config;

import de.tobiyas.util.RaC.collections.CaseInsenesitveMap;
import de.tobiyas.util.RaC.config.DoNotSerialize;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.bukkit.configuration.serialization.ConfigurationSerializable;

public class AutoConfigSerializable
implements ConfigurationSerializable {
    private static final int STATIC_MOD = 8;
    private static final String SERIALIZED_PRE = "SERIALIZED_";

    public void fillWithData(Map<String, Object> serialized) {
        CaseInsenesitveMap<Object> lowercasedMap = new CaseInsenesitveMap<Object>(serialized);
        Class<?> clazz = this.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            if (field == null || AutoConfigSerializable.isFieldStatic(field) || field.getAnnotation(DoNotSerialize.class) != null) continue;
            try {
                String name = field.getName();
                Object toSet = lowercasedMap.get(name);
                if (toSet == null) continue;
                field.setAccessible(true);
                try {
                    field.set(this, AutoConfigSerializable.specialDeserialize(toSet));
                }
                catch (Throwable exp) {
                    exp.printStackTrace();
                }
            }
            catch (Throwable exp) {
                exp.printStackTrace();
            }
        }
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> clazz = this.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            if (field == null || AutoConfigSerializable.isFieldStatic(field) || field.getAnnotation(DoNotSerialize.class) != null) continue;
            try {
                String name = field.getName();
                field.setAccessible(true);
                Object obj = AutoConfigSerializable.specialSerialize(field.get(this));
                if (obj == null) continue;
                map.put(name, obj);
            }
            catch (Throwable exp) {
                exp.printStackTrace();
            }
        }
        return map;
    }

    private static boolean isFieldStatic(Field field) {
        return field != null && (field.getModifiers() & 8) != 0;
    }

    private static Object specialSerialize(Object obj) {
        if (obj == null) {
            return null;
        }
        if (AutoConfigSerializable.isDefaultSerializable(obj)) {
            return obj;
        }
        if (obj instanceof Serializable) {
            obj = AutoConfigSerializable.serializeSerializable((Serializable)obj);
        }
        return obj;
    }

    private static Object specialDeserialize(Object obj) {
        if (obj == null) {
            return null;
        }
        if (AutoConfigSerializable.isDefaultSerializable(obj)) {
            return obj;
        }
        if (obj instanceof String) {
            obj = AutoConfigSerializable.deserializeDeserializable(obj);
        }
        return obj;
    }

    private static boolean isDefaultSerializable(Object obj) {
        if (obj instanceof ConfigurationSerializable) {
            return true;
        }
        if (obj instanceof String) {
            return true;
        }
        if (obj instanceof Boolean) {
            return true;
        }
        if (obj instanceof Number) {
            return true;
        }
        return obj instanceof List;
    }

    private static Object serializeSerializable(Serializable ser) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            objOut.writeObject(ser);
            objOut.flush();
            out.flush();
            return SERIALIZED_PRE + Base64.encodeBase64String((byte[])out.toByteArray());
        }
        catch (Throwable exp) {
            exp.printStackTrace();
            return ser;
        }
    }

    private static Object deserializeDeserializable(Object toDeserialize) {
        if (!(toDeserialize instanceof String)) {
            return toDeserialize;
        }
        String serialized = (String)toDeserialize;
        if (!serialized.startsWith(SERIALIZED_PRE)) {
            return serialized;
        }
        serialized = serialized.substring(SERIALIZED_PRE.length());
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.decodeBase64((String)serialized));
            ObjectInputStream objIn = new ObjectInputStream(in);
            Object obj = objIn.readObject();
            return obj == null ? serialized : obj;
        }
        catch (Throwable throwable) {
            return serialized;
        }
    }
}

