/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.command.params;

import de.tobiyas.util.RaC.command.OptionalCommandParam;
import de.tobiyas.util.RaC.command.params.AbstractCommandParam;
import de.tobiyas.util.RaC.command.params.BooleanCommandParam;
import de.tobiyas.util.RaC.command.params.DoubleCommandParam;
import de.tobiyas.util.RaC.command.params.FloatCommandParam;
import de.tobiyas.util.RaC.command.params.IntegerCommandParam;
import de.tobiyas.util.RaC.command.params.MaterialCommandParam;
import de.tobiyas.util.RaC.command.params.ParameterNotSupportedException;
import de.tobiyas.util.RaC.command.params.PlayerCommandParam;
import de.tobiyas.util.RaC.command.params.StringCommandParam;
import java.lang.reflect.Parameter;
import net.minecraft.server.v1_10_R1.Material;
import org.bukkit.entity.Player;

public class CommandParamFactory {
    public static AbstractCommandParam generateByArg(Parameter param) throws ParameterNotSupportedException {
        Class<?> type = param.getType();
        boolean optional = param.getAnnotationsByType(OptionalCommandParam.class) != null;
        String name = param.getName();
        if (type == Player.class) {
            return new PlayerCommandParam(name, optional);
        }
        if (type == Material.class) {
            return new MaterialCommandParam(name, optional);
        }
        if (type == String.class) {
            return new StringCommandParam(name, optional);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new IntegerCommandParam(name, optional);
        }
        if (type == Double.class || type == Double.TYPE) {
            return new DoubleCommandParam(name, optional);
        }
        if (type == Float.class || type == Float.TYPE) {
            return new FloatCommandParam(name, optional);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return new BooleanCommandParam(name, optional);
        }
        throw new ParameterNotSupportedException(param.getType());
    }
}

