/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.command;

import de.tobiyas.util.RaC.command.AutoRegisterCommand;
import de.tobiyas.util.RaC.command.SubCommand;
import de.tobiyas.util.RaC.command.params.AbstractCommandParam;
import de.tobiyas.util.RaC.command.params.CommandParamFactory;
import de.tobiyas.util.RaC.command.params.ParameterNotSupportedException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class SubCommandInfo {
    private final AutoRegisterCommand command;
    private final SubCommand subCommand;
    private final Method method;
    private final List<AbstractCommandParam> params = new ArrayList<AbstractCommandParam>();

    public SubCommandInfo(AutoRegisterCommand command, Method method) throws ParameterNotSupportedException {
        this.command = command;
        this.subCommand = method.getAnnotation(SubCommand.class);
        this.method = method;
        for (Parameter param : method.getParameters()) {
            this.params.add(CommandParamFactory.generateByArg(param));
        }
    }

    public boolean isAppliable(CommandSender sender, boolean sendMsgToSender) {
        String perm;
        boolean hasPerms;
        if (sender instanceof Player && this.subCommand.consoleOnly()) {
            if (sendMsgToSender) {
                sender.sendMessage(ChatColor.RED + "Only Console may use this command.");
            }
            return false;
        }
        if (sender instanceof ConsoleCommandSender && this.subCommand.playerOnly()) {
            if (sendMsgToSender) {
                sender.sendMessage(ChatColor.RED + "Only Players may use this command.");
            }
            return false;
        }
        boolean bl = hasPerms = this.subCommand.opBypassedPerm() && sender.isOp();
        if (!(hasPerms || (perm = this.command.getMainPerm() + (this.subCommand.appendPermissionToMainCommand() ? "." + this.subCommand.permission() : "")).isEmpty() || sender.hasPermission(perm))) {
            if (sendMsgToSender) {
                sender.sendMessage(ChatColor.RED + "You do not have the Permission to use this command.");
            }
            return false;
        }
        return true;
    }

    public boolean isAppliable(String[] args, CommandSender sender, boolean sendMsgToSender) {
        int argSize = args.length;
        int index = 0;
        for (AbstractCommandParam param : this.params) {
            if (index >= argSize) {
                if (param.isOptional()) continue;
                if (sendMsgToSender) {
                    this.postHelp(sender);
                }
                return false;
            }
            String arg = args[index];
            if (!param.isValid(arg)) {
                if (sendMsgToSender) {
                    param.sendHelp(arg, sender);
                }
                return false;
            }
            ++index;
        }
        return true;
    }

    public void postHelp(CommandSender sender) {
        if (!this.subCommand.help().isEmpty()) {
            sender.sendMessage(ChatColor.RED + this.subCommand.help());
            return;
        }
    }

    public String getSubCommand() {
        return this.subCommand.subCommand();
    }

    public void execute(CommandSender sender, String[] args) {
        try {
            Object[] convArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                convArgs[i] = this.params.get(i).toType(args[i]);
            }
            this.method.invoke((Object)this.command, convArgs);
        }
        catch (Throwable exp) {
            sender.sendMessage(ChatColor.RED + "Could not execute command " + this.command.getCommand() + "" + this.getSubCommand() + "");
            exp.printStackTrace();
        }
    }

    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }
}

