/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.command;

import de.tobiyas.util.RaC.autocomplete.AutoCompleteUtils;
import de.tobiyas.util.RaC.command.SubCommand;
import de.tobiyas.util.RaC.command.SubCommandInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class AutoRegisterCommand
implements TabExecutor {
    private final String mainPerm;
    private final String command;
    private final Collection<SubCommandInfo> subCommands = new ArrayList<SubCommandInfo>();

    public AutoRegisterCommand(JavaPlugin plugin, String command, String mainPerm) {
        this.mainPerm = mainPerm;
        this.command = command;
        PluginCommand pluginCommand = plugin.getCommand(command);
        if (pluginCommand == null) {
            plugin.getLogger().log(Level.SEVERE, "Could not register Command: " + command);
            return;
        }
        for (Method method : this.getClass().getMethods()) {
            if (!method.isAnnotationPresent(SubCommand.class)) continue;
            try {
                this.subCommands.add(new SubCommandInfo(this, method));
            }
            catch (Throwable exp) {
                plugin.getLogger().log(Level.SEVERE, "Could not register Method: '" + method.getName() + "' in Command: '" + command + "'", exp);
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand = args.length == 0 ? "help" : args[0];
        String[] stripped = this.stripFirst(args);
        for (SubCommandInfo info : this.subCommands) {
            String ownSub = info.getSubCommand();
            if (!ownSub.equalsIgnoreCase(subCommand)) continue;
            if (info.isAppliable(sender, true) && info.isAppliable(stripped, sender, true)) {
                info.execute(sender, stripped);
            }
            return true;
        }
        this.postHelp(sender);
        return true;
    }

    private String[] stripFirst(String[] args) {
        return Arrays.copyOfRange(args, 1, args.length);
    }

    private void postHelp(CommandSender sender) {
    }

    public String getMainPerm() {
        return this.mainPerm;
    }

    public String getCommand() {
        return this.command;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length <= 1) {
            HashSet<String> subArgs = new HashSet<String>(Arrays.asList("help"));
            for (SubCommandInfo info : this.subCommands) {
                if (!info.isAppliable(sender, false)) continue;
                subArgs.add(info.getSubCommand());
            }
            return AutoCompleteUtils.getAllNamesWith(subArgs, args.length == 0 ? "" : args[0]);
        }
        if (args.length > 1) {
            String subCommand = args[0];
            for (SubCommandInfo info : this.subCommands) {
                if (!info.getSubCommand().equalsIgnoreCase(subCommand)) continue;
                if (!info.isAppliable(sender, false)) {
                    return null;
                }
                return info.onTabComplete(sender, this.stripFirst(args));
            }
        }
        return null;
    }
}

