/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;

public class CollectionUtils {
    private static final Random rand = new Random();

    public static <T> T getRandomElement(Collection<T> collection, Random rand) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        int num = rand.nextInt(collection.size());
        Iterator<T> it = collection.iterator();
        for (int i = 0; i < num; ++i) {
            it.next();
        }
        return it.next();
    }

    public static <T> T getRandomElement(Collection<T> collection) {
        return CollectionUtils.getRandomElement(collection, rand);
    }

    public static <T> T getRandomElement(T[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array[rand.nextInt(array.length)];
    }

    public static List<String> translateChatColors(List<String> list, char symbol) {
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ChatColor.translateAlternateColorCodes((char)symbol, (String)list.get(i)));
        }
        return list;
    }

    public static List<String> translateChatColors(List<String> list) {
        return CollectionUtils.translateChatColors(list, '&');
    }

    public static void removeNullObjects(Collection<? extends Object> collection) {
        if (collection == null) {
            return;
        }
        CollectionUtils.removeNullObjects(collection.iterator());
    }

    public static void removeNullObjects(Iterator<? extends Object> iterator) {
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
    }

    public static int[] toPrimitive(Integer[] array) {
        int[] array2 = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            array2[i] = array[i];
        }
        return array2;
    }

    public static Integer[] toIntegerArry(int[] array) {
        Integer[] array2 = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            array2[i] = array[i];
        }
        return array2;
    }

    public static double[] toPrimitive(Double[] array) {
        double[] array2 = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            array2[i] = array[i];
        }
        return array2;
    }

    public static Double[] toDoubleArray(double[] array) {
        Double[] array2 = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            array2[i] = array[i];
        }
        return array2;
    }

    public static boolean[] toPrimitive(Boolean[] array) {
        boolean[] array2 = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            array2[i] = array[i];
        }
        return array2;
    }

    public static Boolean[] toBooleanArray(boolean[] array) {
        Boolean[] array2 = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            array2[i] = array[i];
        }
        return array2;
    }

    public static <T> Collection<T> joinCollection(Collection<T> collection1, Collection<T> collection2) {
        collection1.addAll(collection2);
        return collection1;
    }

    public static <T> Collection<T> joinCollection(Collection<T> collection, T element) {
        collection.add(element);
        return collection;
    }

    public static <T> Collection<T> joinCollection(List<T> collection, T ... elements) {
        for (T element : elements) {
            collection.add(element);
        }
        return collection;
    }

    public static <T> List<T> joinList(List<T> list1, List<T> list2) {
        list1.addAll(list2);
        return list1;
    }

    public static <T> List<T> joinList(List<T> list, T element) {
        if (element != null) {
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> joinList(List<T> list, T ... elements) {
        for (T element : elements) {
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }
}

