/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.chat.resolver;

import com.google.gson.JsonObject;
import de.tobiyas.util.RaC.chat.resolver.PlainTextJSONResolver;
import de.tobiyas.util.RaC.naming.MCPrettyName;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;

public class ItemJSONResolver {
    public static String getHoverText(ItemStack itemToParse) {
        if (itemToParse == null) {
            return "";
        }
        String flatLore = "";
        if (itemToParse.hasItemMeta() && itemToParse.getItemMeta().hasLore()) {
            List lore = itemToParse.getItemMeta().hasLore() ? itemToParse.getItemMeta().getLore() : new LinkedList();
            flatLore = ",Lore:[";
            Iterator loreIt = lore.iterator();
            while (loreIt.hasNext()) {
                flatLore = flatLore + "\\\"" + ((String)loreIt.next()).replace(":", "\u00a6").replace("\"", "\\\"") + "\\\"";
                if (!loreIt.hasNext()) continue;
                flatLore = flatLore + ",";
            }
            flatLore = flatLore + "]";
        }
        String name = MCPrettyName.getPrettyName(itemToParse, "de_DE");
        String idString = VollotileCodeManager.getVollotileCode().generateItemIDString(itemToParse);
        short damage = itemToParse.getDurability();
        int count = itemToParse.getAmount();
        String enchantFormat = "";
        if (!itemToParse.getEnchantments().isEmpty()) {
            enchantFormat = ",ench:[";
            Iterator entryIt = itemToParse.getEnchantments().entrySet().iterator();
            while (entryIt.hasNext()) {
                Map.Entry entry = entryIt.next();
                enchantFormat = enchantFormat + "{id:" + ((Enchantment)entry.getKey()).getId() + ",lvl:" + entry.getValue() + "}";
                if (!entryIt.hasNext()) continue;
                enchantFormat = enchantFormat + ",";
            }
            enchantFormat = enchantFormat + "]";
        }
        String storedEnchants = "";
        if (itemToParse.getType() == Material.ENCHANTED_BOOK && itemToParse.hasItemMeta()) {
            EnchantmentStorageMeta enchantedMeta = (EnchantmentStorageMeta)itemToParse.getItemMeta();
            storedEnchants = ",StoredEnchantments:[";
            Iterator entryIt = enchantedMeta.getStoredEnchants().entrySet().iterator();
            while (entryIt.hasNext()) {
                Map.Entry entry = entryIt.next();
                storedEnchants = storedEnchants + "{id:" + ((Enchantment)entry.getKey()).getId() + ",lvl:" + entry.getValue() + "}";
                if (!entryIt.hasNext()) continue;
                storedEnchants = storedEnchants + ",";
            }
            storedEnchants = storedEnchants + "]";
        }
        String potionEffects = "";
        if (itemToParse.getType() == Material.POTION && itemToParse.hasItemMeta()) {
            PotionMeta potionMeta = (PotionMeta)itemToParse.getItemMeta();
            potionEffects = ",CustomPotionEffects:[";
            Iterator entryIt = potionMeta.getCustomEffects().iterator();
            while (entryIt.hasNext()) {
                PotionEffect effect = (PotionEffect)entryIt.next();
                potionEffects = potionEffects + "{id:" + effect.getType().getId() + ",Amplifier:" + effect.getAmplifier() + ",Duration:" + effect.getDuration() + ",Ambient:" + (effect.isAmbient() ? 1 : 0) + "}";
                if (!entryIt.hasNext()) continue;
                potionEffects = potionEffects + ",";
            }
            potionEffects = potionEffects + "]";
        }
        String skullAdd = "";
        if (itemToParse.getType() == Material.SKULL_ITEM && itemToParse.hasItemMeta() && itemToParse.getDurability() == 3 && ((SkullMeta)itemToParse.getItemMeta()).hasOwner()) {
            skullAdd = ",SkullOwner:\\\"" + ((SkullMeta)itemToParse.getItemMeta()).getOwner() + "\\\"";
        }
        String bookAdd = "";
        if (itemToParse.getType() == Material.WRITTEN_BOOK && itemToParse.hasItemMeta()) {
            BookMeta meta = (BookMeta)itemToParse.getItemMeta();
            boolean hasAuthor = meta.hasAuthor();
            boolean hasTitle = meta.hasTitle();
            if (meta.hasAuthor()) {
                bookAdd = bookAdd + ",author:\\\"" + meta.getAuthor() + "\\\"";
            }
            if (hasAuthor && hasTitle) {
                bookAdd = bookAdd + ",";
            }
            if (meta.hasTitle()) {
                bookAdd = bookAdd + "title:\\\"" + meta.getTitle() + "\\\"";
            }
        }
        return "{id:" + idString + ",Count:" + count + ",Damage:" + damage + ",tag:{display:{Name:\\\"" + name + "\\\"" + flatLore + "}" + enchantFormat + storedEnchants + potionEffects + skullAdd + bookAdd + "}}";
    }

    public static String getItemRawHoverText(ItemStack itemToParse, String label) {
        if (itemToParse == null) {
            return "";
        }
        String hoverText = ItemJSONResolver.getHoverText(itemToParse);
        String colorName = "aqua";
        String hoverFormat = "{\"action\":\"show_item\",\"value\":\"" + hoverText + "\"}";
        String name = MCPrettyName.getPrettyName(itemToParse, "de_DE");
        if (label == null || "".equals(label)) {
            label = name;
        }
        String colorCode = ChatColor.getLastColors((String)label);
        String itemFormat = "{\"text\":\"" + colorCode + "[" + label + "]" + colorCode + "\",\"color\":\"" + colorName + "\",\"hoverEvent\":" + hoverFormat + "}";
        return itemFormat;
    }

    public static JsonObject addItemHover(JsonObject toAddTo, ItemStack itemToParse) {
        String hoverText = ItemJSONResolver.getHoverText(itemToParse);
        hoverText = hoverText.replace("\\\"", "\"");
        JsonObject showItem = new JsonObject();
        showItem.addProperty("action", "show_item");
        showItem.addProperty("color", "aqua");
        showItem.addProperty("value", hoverText);
        toAddTo.add("hoverEvent", showItem);
        return toAddTo;
    }

    public static JsonObject getItemRawHoverTextJSON(ItemStack itemToParse, String label) {
        if (itemToParse == null) {
            return new JsonObject();
        }
        if (label == null) {
            label = MCPrettyName.getPrettyName(itemToParse, "de_DE");
        }
        String colorCode = ChatColor.getLastColors((String)label);
        String itemLabel = colorCode + "[" + label + "]";
        JsonObject object = PlainTextJSONResolver.getRawFromPlainTextJSON(itemLabel);
        return ItemJSONResolver.addItemHover(object, itemToParse);
    }
}

