/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.chat.components;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.tobiyas.util.RaC.chat.SendRaw;
import de.tobiyas.util.RaC.chat.components.ChatMessageObject;
import de.tobiyas.util.RaC.naming.MCPrettyName;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TellRawChatMessage {
    private final List<ChatMessageObject> message = new LinkedList<ChatMessageObject>();

    public TellRawChatMessage append(ChatMessageObject messagePart) {
        this.message.add(messagePart);
        return this;
    }

    public void sendToPlayers(Collection<Player> players) {
        if (players.isEmpty()) {
            return;
        }
        String buildMessage = this.buildMessage();
        for (Player player : players) {
            SendRaw.sendPlayerRawMessage(player, buildMessage);
        }
    }

    public String buildMessage() {
        JsonObject message = new JsonObject();
        message.addProperty("text", "");
        JsonArray array = new JsonArray();
        for (int i = 0; i < this.message.size(); ++i) {
            array.add(this.message.get(i).getObject());
        }
        message.add("extra", array);
        return message.toString();
    }

    public String buildBook() {
        JsonObject message = new JsonObject();
        JsonArray array = new JsonArray();
        for (int i = 0; i < this.message.size(); ++i) {
            array.add(this.message.get(i).getObject());
        }
        message.addProperty("text", "");
        message.add("extra", array);
        return message.toString();
    }

    public String buildNormal() {
        String returnString = "";
        for (ChatMessageObject obj : this.message) {
            returnString = returnString + obj.getLabel();
        }
        return returnString;
    }

    public void sendToPlayers(Player ... players) {
        this.sendToPlayers(Arrays.asList(players));
    }

    public TellRawChatMessage addSimpleText(String text) {
        if (text.contains("\u00a7")) {
            this.append(TellRawChatMessage.parse(text));
            return this;
        }
        this.message.add(new ChatMessageObject(text));
        return this;
    }

    public TellRawChatMessage addSimpleText(String text, boolean magic, boolean bold, boolean strikethrough, boolean underlined, boolean italic, ChatColor color) {
        ChatMessageObject obj = new ChatMessageObject(text);
        if (bold) {
            obj.addBold();
        }
        if (strikethrough) {
            obj.addStrikeThrough();
        }
        if (underlined) {
            obj.addUnderlined();
        }
        if (italic) {
            obj.addItalic();
        }
        if (magic) {
            obj.addMagic();
        }
        if (color != null) {
            obj.addChatColor(color);
        }
        this.message.add(obj);
        return this;
    }

    public TellRawChatMessage addSimpleItem(ItemStack item) {
        if (item == null) {
            return this;
        }
        String name = MCPrettyName.getPrettyName(item, "de_DE");
        String last = ChatColor.getLastColors((String)name);
        name = last + "[" + name + last + "]";
        this.addSimpleItem(item, name);
        return this;
    }

    public TellRawChatMessage addSimpleItem(ItemStack item, String label) {
        if (item == null) {
            return this;
        }
        ChatMessageObject obj = new ChatMessageObject(label);
        obj.addItemHover(item);
        this.message.add(obj);
        return this;
    }

    public TellRawChatMessage addSimplePopup(String label, String message) {
        ChatMessageObject obj = new ChatMessageObject(label);
        obj.addPopupHover(message);
        this.message.add(obj);
        return this;
    }

    public TellRawChatMessage addSimpleURL(String label, String URL2) {
        ChatMessageObject obj = new ChatMessageObject(label);
        obj.addURLClickable(URL2);
        this.message.add(obj);
        return this;
    }

    public TellRawChatMessage addSimpleCommand(String label, String command) {
        ChatMessageObject obj = new ChatMessageObject(label);
        obj.addCommandClickable(command);
        this.message.add(obj);
        return this;
    }

    public TellRawChatMessage addSimpleCommand(String label, String hover, String command) {
        ChatMessageObject obj = new ChatMessageObject(label);
        obj.addCommandClickable(command);
        obj.addPopupHover(hover);
        this.message.add(obj);
        return this;
    }

    public TellRawChatMessage addSimpleCommandSuggestion(String label, String commandSuggestion) {
        ChatMessageObject obj = new ChatMessageObject(label);
        obj.addCommandSuggestionClickable(commandSuggestion);
        this.message.add(obj);
        return this;
    }

    public TellRawChatMessage append(TellRawChatMessage buildTellRawMessage) {
        for (ChatMessageObject obj : buildTellRawMessage.message) {
            this.message.add(obj);
        }
        return this;
    }

    public TellRawChatMessage addNewLine() {
        this.addSimpleText("\n");
        return this;
    }

    public String toString() {
        return this.buildMessage();
    }

    public static TellRawChatMessage parse(String message) {
        String[] split;
        if (!message.contains("\u00a7")) {
            return new TellRawChatMessage().addSimpleText(message);
        }
        boolean magic = false;
        boolean bold = false;
        boolean strikethrough = false;
        boolean underlined = false;
        boolean italic = false;
        ChatColor currentColor = ChatColor.WHITE;
        TellRawChatMessage tellRaw = new TellRawChatMessage();
        for (String sub : split = message.split("\u00a7")) {
            if (sub.length() == 0) continue;
            char toParse = sub.charAt(0);
            if (toParse >= '0' && toParse <= '9' || toParse >= 'a' && toParse <= 'f') {
                currentColor = ChatColor.getByChar((char)toParse);
            }
            if (toParse == 'k') {
                magic = true;
            }
            if (toParse == 'l') {
                bold = true;
            }
            if (toParse == 'm') {
                strikethrough = true;
            }
            if (toParse == 'n') {
                underlined = true;
            }
            if (toParse == 'o') {
                italic = true;
            }
            if (toParse == 'r') {
                bold = false;
                strikethrough = false;
                underlined = false;
                italic = false;
            }
            sub = sub.substring(1);
            tellRaw.addSimpleText(sub, magic, bold, strikethrough, underlined, italic, currentColor);
        }
        return tellRaw;
    }
}

