/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.chat.components;

import com.google.gson.JsonObject;
import de.tobiyas.util.RaC.chat.resolver.CommandJSONResolver;
import de.tobiyas.util.RaC.chat.resolver.CommandSuggestionJSONResolver;
import de.tobiyas.util.RaC.chat.resolver.ItemJSONResolver;
import de.tobiyas.util.RaC.chat.resolver.PlainTextJSONResolver;
import de.tobiyas.util.RaC.chat.resolver.PopupJSONResolver;
import de.tobiyas.util.RaC.chat.resolver.TextStyleJSONResolver;
import de.tobiyas.util.RaC.chat.resolver.URLJSONResolver;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public class ChatMessageObject {
    private final JsonObject ownObject;

    public ChatMessageObject(String label) {
        this.ownObject = PlainTextJSONResolver.getRawFromPlainTextJSON(label);
    }

    public ChatMessageObject addItemHover(ItemStack item) {
        ItemJSONResolver.addItemHover(this.ownObject, item);
        return this;
    }

    public ChatMessageObject addPopupHover(String message) {
        PopupJSONResolver.addPopupHover(this.ownObject, message);
        return this;
    }

    public ChatMessageObject addURLClickable(String url) {
        URLJSONResolver.addURLClickable(this.ownObject, url);
        return this;
    }

    public ChatMessageObject addCommandClickable(String command) {
        if (!command.startsWith("/")) {
            command = "/" + command;
        }
        CommandJSONResolver.addCommandClickable(this.ownObject, command);
        return this;
    }

    public ChatMessageObject addCommandSuggestionClickable(String command) {
        CommandSuggestionJSONResolver.addCommandSuggestionClickable(this.ownObject, command);
        return this;
    }

    public ChatMessageObject changeText(String newText) {
        this.ownObject.addProperty("text", newText);
        return this;
    }

    public ChatMessageObject addChatColor(ChatColor color) {
        TextStyleJSONResolver.addColor(this.ownObject, color);
        return this;
    }

    public ChatMessageObject addStrikeThrough() {
        TextStyleJSONResolver.addStrikethrough(this.ownObject);
        return this;
    }

    public ChatMessageObject addUnderlined() {
        TextStyleJSONResolver.addUnderlined(this.ownObject);
        return this;
    }

    public ChatMessageObject addItalic() {
        TextStyleJSONResolver.addItalic(this.ownObject);
        return this;
    }

    public ChatMessageObject addBold() {
        TextStyleJSONResolver.addBold(this.ownObject);
        return this;
    }

    public ChatMessageObject addMagic() {
        TextStyleJSONResolver.addMagic(this.ownObject);
        return this;
    }

    public ChatMessageObject removeStrikeThrough() {
        TextStyleJSONResolver.removeStrikethrough(this.ownObject);
        return this;
    }

    public ChatMessageObject removeUnderlined() {
        TextStyleJSONResolver.removeUnderlined(this.ownObject);
        return this;
    }

    public ChatMessageObject removeItalic() {
        TextStyleJSONResolver.removeItalic(this.ownObject);
        return this;
    }

    public ChatMessageObject removeBold() {
        TextStyleJSONResolver.removeBold(this.ownObject);
        return this;
    }

    public ChatMessageObject removeMagic() {
        TextStyleJSONResolver.removeMagic(this.ownObject);
        return this;
    }

    protected JsonObject getObject() {
        return this.ownObject;
    }

    public String getLabel() {
        if (!this.ownObject.has("text")) {
            return "";
        }
        return this.ownObject.get("text").getAsString();
    }
}

