/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.chat.commands;

import de.tobiyas.util.RaC.UtilsUsingPlugin;
import de.tobiyas.util.RaC.chat.commands.ClickCommand;
import de.tobiyas.util.RaC.chat.commands.CommandCallback;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class ClickCommandManager
implements Listener {
    private final Map<UUID, Map<ClickCommand, Long>> clickCommands = new HashMap<UUID, Map<ClickCommand, Long>>();
    private final Map<String, Long> oldCommands = new HashMap<String, Long>();
    private final long MAX_LENGTH = 300000L;

    public ClickCommandManager(UtilsUsingPlugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public String registerCommand(Player player, String hint, CommandCallback callback) {
        ClickCommand command = new ClickCommand(player, hint, callback);
        HashMap<ClickCommand, Long> playerMap = this.clickCommands.containsKey(player.getUniqueId()) ? this.clickCommands.get(player.getUniqueId()) : new HashMap<ClickCommand, Long>();
        playerMap.put(command, System.currentTimeMillis());
        this.clickCommands.put(player.getUniqueId(), playerMap);
        return command.getName();
    }

    public void removeCommand(String name) {
        this.oldCommands.remove(name);
        long currentTime = System.currentTimeMillis();
        for (Map<ClickCommand, Long> element : this.clickCommands.values()) {
            Iterator<Map.Entry<ClickCommand, Long>> it = element.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ClickCommand, Long> entry = it.next();
                ClickCommand command = entry.getKey();
                long time = entry.getValue();
                if (currentTime - time > 300000L) {
                    it.remove();
                    continue;
                }
                String commandName = command.getName();
                if (!name.equals(commandName)) continue;
                it.remove();
                return;
            }
        }
    }

    @EventHandler
    public void playerCommandCheck(PlayerCommandPreprocessEvent event) {
        if (event.getMessage().length() < 2) {
            return;
        }
        String commandName = event.getMessage().substring(1);
        Player player = event.getPlayer();
        if (commandName.contains(" ")) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<String, Long>> oldCommandIt = new HashMap<String, Long>(this.oldCommands).entrySet().iterator();
        while (oldCommandIt.hasNext()) {
            Map.Entry<String, Long> entry = oldCommandIt.next();
            long time = entry.getValue();
            if (currentTime - time <= 300000L) continue;
            oldCommandIt.remove();
        }
        currentTime = System.currentTimeMillis();
        Map<ClickCommand, Long> clickComands = this.clickCommands.get(player.getUniqueId());
        if (clickComands == null) {
            return;
        }
        Iterator<Map.Entry<ClickCommand, Long>> commandIt = clickComands.entrySet().iterator();
        while (commandIt.hasNext()) {
            Map.Entry<ClickCommand, Long> entry = commandIt.next();
            ClickCommand command = entry.getKey();
            long time = entry.getValue();
            if (currentTime - time > 300000L) {
                commandIt.remove();
                continue;
            }
            String name = command.getName();
            if (!name.equals(commandName)) continue;
            commandIt.remove();
            this.oldCommands.put(name, currentTime);
            event.setMessage("/");
            event.setCancelled(true);
            command.trigger(player);
            return;
        }
    }
}

