/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.chat.chatmenu.elements;

import de.tobiyas.util.RaC.UtilsUsingPlugin;
import de.tobiyas.util.RaC.chat.chatmenu.elements.ChatMenuElement;
import de.tobiyas.util.RaC.chat.commands.CommandCallback;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public abstract class ChatMenuView
implements CommandCallback {
    protected final String commandName;
    protected final UtilsUsingPlugin plugin;
    protected final Player player;
    protected String heading = ChatColor.YELLOW + "--------------------";
    protected String footer = ChatColor.YELLOW + "--------------------";
    protected final List<ChatMenuElement> elements = new LinkedList<ChatMenuElement>();

    public ChatMenuView(Player player, UtilsUsingPlugin plugin) {
        this.player = player;
        this.plugin = plugin;
        this.commandName = plugin.getClickCommandManager().registerCommand(player, "", this);
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public void addElement(ChatMenuElement element) {
        this.elements.add(element);
    }

    public void postToPlayer() {
        this.rebuild();
        if (this.heading != null && !this.heading.isEmpty()) {
            this.player.sendMessage(this.heading);
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).post();
        }
        if (this.footer != null && !this.footer.isEmpty()) {
            this.player.sendMessage(this.footer);
        }
    }

    protected abstract void rebuild();

    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void playerPressedCallback(Player player, String hint) {
        this.postToPlayer();
    }
}

