/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.chat.chatmenu.elements;

import de.tobiyas.util.RaC.chat.chatmenu.elements.ChatMenuView;
import de.tobiyas.util.RaC.chat.components.ChatMessageObject;
import de.tobiyas.util.RaC.chat.components.TellRawChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class ChatMenuElement {
    protected final Player player;
    protected final String label;
    protected String clickCommand;
    protected String clickCommandSuggestion;
    protected String popupLabel;
    protected ItemStack itemPopup;
    protected String urlClick;
    protected ChatMenuView newViewToShow;

    public ChatMenuElement(Player player, String label) {
        this.player = player;
        this.label = label;
    }

    public ChatMenuElement setClickCommand(String clickCommand) {
        this.clickCommand = clickCommand;
        return this;
    }

    public ChatMenuElement setClickCommandSuggestion(String clickCommandSuggestion) {
        this.clickCommandSuggestion = clickCommandSuggestion;
        return this;
    }

    public ChatMenuElement setPopupLabel(String popupLabel) {
        this.popupLabel = popupLabel;
        return this;
    }

    public ChatMenuElement setItemPopup(ItemStack itemPopup) {
        this.itemPopup = itemPopup;
        return this;
    }

    public ChatMenuElement setUrlClick(String urlClick) {
        this.urlClick = urlClick;
        return this;
    }

    public ChatMenuView getNewViewToShow() {
        return this.newViewToShow;
    }

    public ChatMenuElement setNewViewToShow(ChatMenuView newViewToShow) {
        this.newViewToShow = newViewToShow;
        return this;
    }

    protected abstract void rebuild();

    public Player getPlayer() {
        return this.player;
    }

    public String getLabel() {
        return this.label;
    }

    public String getClickCommand() {
        return this.clickCommand;
    }

    public String getPopupLabel() {
        return this.popupLabel;
    }

    public ItemStack getItemPopup() {
        return this.itemPopup;
    }

    public String getUrlClick() {
        return this.urlClick;
    }

    protected TellRawChatMessage buildTellRawMessage() {
        this.rebuild();
        ChatMessageObject obj = new ChatMessageObject(this.label);
        if (this.itemPopup != null) {
            obj.addItemHover(this.itemPopup);
        }
        if (this.popupLabel != null) {
            obj.addPopupHover(this.popupLabel);
        }
        if (this.urlClick != null) {
            obj.addURLClickable(this.urlClick);
        }
        if (this.clickCommand != null) {
            obj.addCommandClickable(this.clickCommand);
        }
        if (this.clickCommandSuggestion != null) {
            obj.addCommandSuggestionClickable(this.clickCommandSuggestion);
        }
        if (this.newViewToShow != null) {
            obj.addCommandClickable(this.newViewToShow.getCommandName());
        }
        return new TellRawChatMessage().append(obj);
    }

    public void post() {
        this.buildTellRawMessage().sendToPlayers(this.player);
    }
}

