/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.chat;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.tobiyas.util.RaC.chat.SendRaw;
import de.tobiyas.util.RaC.chat.resolver.AchievementJSONResolver;
import de.tobiyas.util.RaC.chat.resolver.CommandJSONResolver;
import de.tobiyas.util.RaC.chat.resolver.ItemJSONResolver;
import de.tobiyas.util.RaC.chat.resolver.PlainTextJSONResolver;
import de.tobiyas.util.RaC.chat.resolver.PopupJSONResolver;
import de.tobiyas.util.RaC.chat.resolver.URLJSONResolver;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class JSONRawSender {
    private Queue<ChatResolve> messageQueue = new LinkedList<ChatResolve>();

    public JSONRawSender append(String message) {
        if (!"".equals(message)) {
            this.messageQueue.add(new ChatResolve(ChatResolveType.UNFORMATED_TEXT, message, null));
        }
        return this;
    }

    public JSONRawSender appendRaw(String message) {
        this.messageQueue.add(new ChatResolve(ChatResolveType.RAW, message, null));
        return this;
    }

    public JSONRawSender appendCommand(String command, String label) {
        this.messageQueue.add(new ChatResolve(ChatResolveType.COMMAND, command, label));
        return this;
    }

    public JSONRawSender appendURL(String url, String label) {
        this.messageQueue.add(new ChatResolve(ChatResolveType.URL, url, label));
        return this;
    }

    public JSONRawSender append(ItemStack item, String customLabel) {
        this.messageQueue.add(new ChatResolve(ChatResolveType.ITEM, item, customLabel));
        return this;
    }

    public JSONRawSender append(ItemStack item) {
        this.messageQueue.add(new ChatResolve(ChatResolveType.ITEM, item, null));
        return this;
    }

    public JSONRawSender appendAchievement(String achievement, String customLabel) {
        this.messageQueue.add(new ChatResolve(ChatResolveType.ACHIEVEMENT, achievement, customLabel));
        return this;
    }

    public JSONRawSender appendPopup(String popupMessage, String customLabel) {
        this.messageQueue.add(new ChatResolve(ChatResolveType.POPUP, popupMessage, customLabel));
        return this;
    }

    public String buildRawMessage() {
        String rawMessage = "{\"text\":\"\",\"extra\":[";
        LinkedList<ChatResolve> copy = new LinkedList<ChatResolve>(this.messageQueue);
        while (!copy.isEmpty()) {
            ChatResolve resolver = (ChatResolve)copy.poll();
            switch (resolver.getType()) {
                case UNFORMATED_TEXT: {
                    rawMessage = rawMessage + PlainTextJSONResolver.getRawFromPlainText((String)resolver.getToParse());
                    break;
                }
                case ITEM: {
                    rawMessage = rawMessage + ItemJSONResolver.getItemRawHoverText((ItemStack)resolver.getToParse(), resolver.getLabel());
                    break;
                }
                case ACHIEVEMENT: {
                    rawMessage = rawMessage + AchievementJSONResolver.resolveAchievement((String)resolver.getToParse(), resolver.getLabel());
                    break;
                }
                case URL: {
                    rawMessage = rawMessage + URLJSONResolver.resolveURL((String)resolver.getToParse(), resolver.getLabel());
                    break;
                }
                case COMMAND: {
                    rawMessage = rawMessage + CommandJSONResolver.resolveCommand((String)resolver.getToParse(), resolver.getLabel());
                    break;
                }
                case POPUP: {
                    rawMessage = rawMessage + PopupJSONResolver.resolve((String)resolver.getToParse(), resolver.getLabel());
                    break;
                }
                case RAW: {
                    rawMessage = rawMessage + (String)resolver.getToParse();
                }
            }
            if (copy.isEmpty()) continue;
            rawMessage = rawMessage + ",";
        }
        rawMessage = rawMessage + "]}";
        return rawMessage;
    }

    public JsonObject buildRawMessageFromJSON() {
        JsonObject object = new JsonObject();
        object.addProperty("text", "");
        JsonArray extra = new JsonArray();
        LinkedList<ChatResolve> copy = new LinkedList<ChatResolve>(this.messageQueue);
        while (!copy.isEmpty()) {
            ChatResolve resolver = (ChatResolve)copy.poll();
            switch (resolver.getType()) {
                case UNFORMATED_TEXT: {
                    extra.add(PlainTextJSONResolver.getRawFromPlainTextJSON((String)resolver.getToParse()));
                    break;
                }
                case ITEM: {
                    extra.add(ItemJSONResolver.getItemRawHoverTextJSON((ItemStack)resolver.getToParse(), resolver.getLabel()));
                    break;
                }
                case ACHIEVEMENT: {
                    extra.add(AchievementJSONResolver.resolveAchievementJSON((String)resolver.getToParse(), resolver.getLabel()));
                    break;
                }
                case URL: {
                    extra.add(URLJSONResolver.resolveURLJSON((String)resolver.getToParse(), resolver.getLabel()));
                    break;
                }
                case COMMAND: {
                    extra.add(CommandJSONResolver.resolveCommandJSON((String)resolver.getToParse(), resolver.getLabel()));
                    break;
                }
                case POPUP: {
                    extra.add(PopupJSONResolver.resolveJSON((String)resolver.getToParse(), resolver.getLabel()));
                    break;
                }
                case RAW: {
                    extra.add(new JsonParser().parse((String)resolver.getToParse()));
                }
            }
        }
        object.add("extra", extra);
        return object;
    }

    public String buildRawMessageFromJSONAsString() {
        return this.buildRawMessageFromJSON().toString();
    }

    public void sendToPlayers(Player ... players) {
        String message = this.buildRawMessage();
        for (Player player : players) {
            SendRaw.sendPlayerRawMessage(player, message);
        }
    }

    public void sendToPlayers(Collection<Player> players) {
        String message = this.buildRawMessage();
        for (Player player : players) {
            SendRaw.sendPlayerRawMessage(player, message);
        }
    }

    public void sendJSONToPlayers(Player ... players) {
        String message = this.buildRawMessageFromJSONAsString();
        for (Player player : players) {
            SendRaw.sendPlayerRawMessage(player, message);
        }
    }

    public void sendJSONToPlayers(Collection<Player> players) {
        String message = this.buildRawMessageFromJSONAsString();
        for (Player player : players) {
            SendRaw.sendPlayerRawMessage(player, message);
        }
    }

    public static class ChatResolve {
        private final ChatResolveType type;
        private final Object toParse;
        private final String label;

        public ChatResolve(ChatResolveType type, Object toParse, String label) {
            this.type = type;
            this.toParse = toParse;
            this.label = label;
        }

        public ChatResolveType getType() {
            return this.type;
        }

        public Object getToParse() {
            return this.toParse;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum ChatResolveType {
        ITEM,
        UNFORMATED_TEXT,
        ACHIEVEMENT,
        URL,
        COMMAND,
        POPUP,
        RAW;

    }
}

