/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC.autocomplete;

import de.tobiyas.util.RaC.player.PlayerUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class AutoCompleteUtils {
    public static List<String> getAllNamesWith(Collection<String> names, String pre) {
        LinkedList<String> list = new LinkedList<String>();
        for (String name : names) {
            if (!name.toLowerCase().startsWith(pre.toLowerCase()) && !"".equals(pre)) continue;
            list.add(name);
        }
        Collections.sort(list);
        return list;
    }

    public static List<String> getAllObjectNamesWith(Collection<? extends Object> objects, String pre) {
        LinkedList<String> list = new LinkedList<String>();
        for (Object object : objects) {
            String name = object.toString();
            if (!name.toLowerCase().startsWith(pre.toLowerCase()) && !"".equals(pre)) continue;
            list.add(name);
        }
        return list;
    }

    public static List<String> getAllObjectNamesWithReplaceSpace(Collection<? extends Object> objects, String pre) {
        LinkedList<String> list = new LinkedList<String>();
        for (Object object : objects) {
            String name = object.toString().replace(" ", "_");
            if (!name.toLowerCase().startsWith(pre.toLowerCase()) && !"".equals(pre)) continue;
            list.add(name);
        }
        return list;
    }

    public static List<String> getAllNamesWith(String pre, String ... toUse) {
        return AutoCompleteUtils.getAllNamesWith(Arrays.asList(toUse), pre);
    }

    public static List<String> getAllEntitiesWith(String pre) {
        LinkedList<String> list = new LinkedList<String>();
        for (EntityType entityName : EntityType.values()) {
            if (!entityName.name().toLowerCase().startsWith(pre.toLowerCase()) && !"".equals(pre)) continue;
            list.add(entityName.name());
        }
        return list;
    }

    public static List<String> getAllMonsterWith(String pre) {
        LinkedList<String> list = new LinkedList<String>();
        for (EntityType entityName : EntityType.values()) {
            if (!entityName.name().toLowerCase().startsWith(pre.toLowerCase()) && !"".equals(pre)) continue;
            list.add(entityName.name());
        }
        return list;
    }

    public static List<String> getAllMaterialsWith(String pre) {
        LinkedList<String> list = new LinkedList<String>();
        for (Material material : Material.values()) {
            if (!material.name().toLowerCase().startsWith(pre.toLowerCase()) && !"".equals(pre)) continue;
            list.add(material.name());
        }
        return list;
    }

    public static List<String> getAllBlockMaterialsWith(String pre) {
        LinkedList<String> list = new LinkedList<String>();
        for (Material material : Material.values()) {
            if (!material.isBlock() || !material.name().toLowerCase().startsWith(pre.toLowerCase()) && !"".equals(pre)) continue;
            list.add(material.name());
        }
        return list;
    }

    public static List<String> getAllNonBlockMaterialsWith(String pre) {
        LinkedList<String> list = new LinkedList<String>();
        for (Material material : Material.values()) {
            if (material.isBlock() || !material.name().toLowerCase().startsWith(pre.toLowerCase()) && !"".equals(pre)) continue;
            list.add(material.name());
        }
        return list;
    }

    public static List<String> getAllPlayersWith(String pre) {
        pre = pre.toLowerCase();
        LinkedList<String> names = new LinkedList<String>();
        try {
            for (Player player : PlayerUtils.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(pre)) continue;
                names.add(player.getName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return names;
    }
}

