/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.util.RaC;

import de.tobiyas.util.RaC.chat.commands.ClickCommandManager;
import de.tobiyas.util.RaC.debug.logger.DebugLogger;
import de.tobiyas.util.RaC.economy.MoneyManager;
import de.tobiyas.util.RaC.permissions.PermissionManager;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import de.tobiyas.util.RaC.schedule.RunBukkitRunnable;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.scheduler.BukkitTask;
import org.mcstats.Metrics;

public abstract class UtilsUsingPlugin
extends JavaPlugin {
    private PermissionManager permManager;
    private DebugLogger debugLogger;
    private MoneyManager moneyManager;
    private ClickCommandManager clickCommandManager;
    private static UtilsUsingPlugin plugin;

    public UtilsUsingPlugin() {
        plugin = this;
    }

    protected UtilsUsingPlugin(Server server, JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
        plugin = this;
    }

    public final void onEnable() {
        this.getDebugLogger().setAlsoToPlugin(true);
        VollotileCodeManager.init(this);
        new DebugBukkitRunnable("StartTick"){

            @Override
            protected void runIntern() {
                UtilsUsingPlugin.this.firstTick();
                if (UtilsUsingPlugin.this.useMetrics()) {
                    try {
                        new Metrics((Plugin)UtilsUsingPlugin.this).start();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }.runTaskLater((Plugin)this, 1L);
        this.pluginEnable();
    }

    protected abstract void pluginEnable();

    protected void firstTick() {
    }

    public void registerEvents(Listener listener) {
        if (listener == null) {
            return;
        }
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public void registerPluginMessage(PluginMessageListener listener, String channel) {
        if (listener == null || channel == null || channel.isEmpty()) {
            return;
        }
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, channel, listener);
    }

    public PermissionManager getPermissionManager() {
        if (this.permManager == null) {
            this.permManager = new PermissionManager(this);
        }
        return this.permManager;
    }

    public DebugLogger getDebugLogger() {
        if (this.debugLogger == null) {
            this.debugLogger = new DebugLogger(this);
        }
        return this.debugLogger;
    }

    public MoneyManager getMoneyManager() {
        if (this.moneyManager == null) {
            this.moneyManager = new MoneyManager(this);
        }
        return this.moneyManager;
    }

    public ClickCommandManager getClickCommandManager() {
        if (this.clickCommandManager == null) {
            this.clickCommandManager = new ClickCommandManager(this);
        }
        return this.clickCommandManager;
    }

    public void log(String message) {
        this.getDebugLogger().log(message);
    }

    public void logWarning(String message) {
        this.getDebugLogger().logWarning(message);
    }

    public void logError(String message) {
        this.getDebugLogger().logError(message);
    }

    public void logDebug(String message) {
        this.getDebugLogger().logDebug(message);
    }

    public void logStackTrace(String message, Throwable exp) {
        if (message == null || "".equals(message)) {
            message = exp.getLocalizedMessage();
        }
        this.logError(message);
        this.getDebugLogger().logStackTrace(exp);
    }

    protected boolean useMetrics() {
        return false;
    }

    public void callEvent(final Event event) {
        boolean async = event.isAsynchronous();
        DebugBukkitRunnable run = new DebugBukkitRunnable("UtilsCallEvent"){

            @Override
            public void runIntern() {
                Bukkit.getPluginManager().callEvent(event);
            }
        };
        if (async) {
            run.runTaskAsynchronously((Plugin)this);
        } else {
            run.runTask((Plugin)this);
        }
    }

    public static BukkitTask RunSync(Runnable run) {
        if (!plugin.isEnabled()) {
            return null;
        }
        return plugin == null ? null : new RunBukkitRunnable(run).runTask((Plugin)plugin);
    }

    public static BukkitTask RunSync(Runnable run, int ticks) {
        if (!plugin.isEnabled()) {
            return null;
        }
        return plugin == null ? null : new RunBukkitRunnable(run).runTaskLater((Plugin)plugin, ticks);
    }

    public static BukkitTask RunAsync(Runnable run) {
        if (!plugin.isEnabled()) {
            return null;
        }
        return plugin == null ? null : new RunBukkitRunnable(run).runTaskAsynchronously((Plugin)plugin);
    }

    public static BukkitTask RunAsync(Runnable run, int ticks) {
        if (!plugin.isEnabled()) {
            return null;
        }
        return plugin == null ? null : new RunBukkitRunnable(run).runTaskLaterAsynchronously((Plugin)plugin, ticks);
    }
}

