/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.vollotile;

import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.vollotile.VollotileCodeManager;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Vollotile {
    private static Vollotile instance;
    private final int MAX_PARTICLE_RANGE = 4096;

    public static Vollotile get() {
        if (instance == null) {
            instance = new Vollotile();
        }
        return instance;
    }

    public void playCriticalHitEffect(Player toSendTo, Entity toPlayEffect) {
        VollotileCodeManager.getVollotileCode().playCriticalHitEffect(toSendTo, toPlayEffect);
    }

    public void playCriticalHitEffect(Entity toPlayEffect) {
        VollotileCodeManager.getVollotileCode().playCriticalHitEffect(toPlayEffect);
    }

    public void sendRawMessage(Player player, String rawMessage) {
        VollotileCodeManager.getVollotileCode().sendRawMessage(player, rawMessage);
    }

    public void removeParticleEffect(LivingEntity entity) {
        VollotileCodeManager.getVollotileCode().removeParticleEffect(entity);
    }

    public void sendOwnParticleEffect(ParticleEffects effect, Location loc, Vector width, float data, int amount, Player player) {
        if (effect == null) {
            return;
        }
        if (player.getWorld() != loc.getWorld() || player.getLocation().distanceSquared(loc) > 4096.0) {
            return;
        }
        Effect bukkitEffect = effect.asBukkit();
        if (bukkitEffect != null) {
            loc.getWorld().playEffect(loc, bukkitEffect, (int)data);
        } else {
            VollotileCodeManager.getVollotileCode().sendParticleEffect(effect.asMirror(), loc, width, data, amount, player);
        }
    }

    public void sendOwnParticleEffectToAll(ParticleEffects effect, Location loc, float data, int amount) {
        if (effect == null) {
            return;
        }
        this.sendOwnParticleEffectToAll(effect, loc, new Vector(0.1, 0.1, 0.1), data, amount);
    }

    public void sendOwnParticleEffectToAll(ParticleContainer container, Location loc) {
        if (container == null) {
            return;
        }
        this.sendOwnParticleEffectToAll(container.getEffect(), loc, container.getVec(), container.getData(), container.getAmount());
    }

    public void sendOwnParticleEffectToAll(ParticleEffects effect, Location loc, Vector width, float data, int amount) {
        if (effect == null) {
            return;
        }
        for (Player pl : loc.getWorld().getPlayers()) {
            this.sendOwnParticleEffect(effect, loc, width, data, amount, pl);
        }
    }

    public void sendParticleEffect(de.tobiyas.util.RaC.vollotile.ParticleEffects effect, Location loc, Vector width, float data, int amount, Player player) {
        VollotileCodeManager.getVollotileCode().sendParticleEffect(effect, loc, width, data, amount, player);
    }

    public void sendParticleEffectToAll(de.tobiyas.util.RaC.vollotile.ParticleEffects effect, Location loc, float data, int amount) {
        VollotileCodeManager.getVollotileCode().sendParticleEffectToAll(effect, loc, data, amount);
    }

    public void makeArrowPickupable(Arrow arrow, boolean mayBePickedUp) {
        VollotileCodeManager.getVollotileCode().makeArrowPickupable(arrow, mayBePickedUp);
    }

    public boolean isCorrectVersion() {
        return VollotileCodeManager.getVollotileCode().isCorrectVersion();
    }

    public String toString() {
        return VollotileCodeManager.getVollotileCode().toString();
    }
}

