/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.util.traitutil;

import com.sk89q.worldguard.bukkit.WGBukkit;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.resolvers.WorldResolver;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class TraitRegionChecker {
    public static boolean isInDisabledLocation(Location location) {
        if (location == null) {
            return false;
        }
        if (WorldResolver.isDisabledWorld(location.getWorld())) {
            return true;
        }
        Set<String> disabledRegions = RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().getConfig_disabledRegions();
        if (disabledRegions.isEmpty()) {
            return false;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") == null) {
            return false;
        }
        World world = location.getWorld();
        ApplicableRegionSet regions = WGBukkit.getRegionManager((World)world).getApplicableRegions(location);
        for (ProtectedRegion region : regions) {
            for (String disabled : disabledRegions) {
                if (!region.getId().equalsIgnoreCase(disabled)) continue;
                return true;
            }
        }
        return false;
    }
}

