/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.util.traitutil;

public class TraitPriority {
    public static final int last = 0;
    public static final int lowest = 1;
    public static final int low = 2;
    public static final int middle = 3;
    public static final int high = 4;
    public static final int highest = 5;
    public static final int first = 6;
    private int prio;

    private TraitPriority(int prio) {
        this.prio = prio;
    }

    public int getPrio() {
        return this.prio;
    }

    public static TraitPriority createPriority(int prio) {
        switch (prio) {
            case 0: {
                return TraitPriority.last();
            }
            case 1: {
                return TraitPriority.lowest();
            }
            case 2: {
                return TraitPriority.low();
            }
            case 3: {
                return TraitPriority.middle();
            }
            case 4: {
                return TraitPriority.high();
            }
            case 5: {
                return TraitPriority.highest();
            }
            case 6: {
                return TraitPriority.first();
            }
        }
        return TraitPriority.middle();
    }

    public boolean isHigherThan(TraitPriority second) {
        return this.prio > second.getPrio();
    }

    public boolean isLowerThan(TraitPriority second) {
        return this.prio < second.getPrio();
    }

    public static TraitPriority last() {
        return new TraitPriority(0);
    }

    public static TraitPriority lowest() {
        return new TraitPriority(1);
    }

    public static TraitPriority low() {
        return new TraitPriority(2);
    }

    public static TraitPriority middle() {
        return new TraitPriority(3);
    }

    public static TraitPriority high() {
        return new TraitPriority(4);
    }

    public static TraitPriority highest() {
        return new TraitPriority(5);
    }

    public static TraitPriority first() {
        return new TraitPriority(6);
    }
}

