/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.util.traitutil;

import de.tobiyas.racesandclasses.util.friend.TargetType;
import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.collections.CaseInsenesitveMap;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.potion.PotionEffectType;

public class TraitConfiguration
extends CaseInsenesitveMap<Object> {
    private static final long serialVersionUID = 1837146794134038024L;
    private final YamlConfiguration config;

    public TraitConfiguration(YamlConfiguration config) {
        this.config = config;
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public String getAsString(String key) {
        return this.getAsString(key, null);
    }

    public String getAsString(String key, String defaultValue) {
        Object obj = this.get(key);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public int getAsInt(String key) {
        return this.getAsInt(key, Integer.MIN_VALUE);
    }

    public int getAsInt(String key, int defaultValue) {
        Object obj = this.get(key);
        int returnValue = defaultValue;
        if (obj == null) {
            return returnValue;
        }
        if (obj instanceof Integer) {
            returnValue = (Integer)obj;
        }
        if (obj instanceof Double) {
            returnValue = ((Double)obj).intValue();
        }
        if (obj instanceof Float) {
            returnValue = ((Float)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                returnValue = Integer.parseInt((String)obj);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return returnValue;
    }

    public double getAsDouble(String key) {
        return this.getAsDouble(key, Double.MIN_VALUE);
    }

    public double getAsDouble(String key, double defaultValue) {
        Object obj = this.get(key);
        double returnValue = defaultValue;
        if (obj == null) {
            return returnValue;
        }
        if (obj instanceof Integer) {
            returnValue = ((Integer)obj).intValue();
        }
        if (obj instanceof Double) {
            returnValue = (Double)obj;
        }
        if (obj instanceof Float) {
            returnValue = ((Float)obj).floatValue();
        }
        if (obj instanceof String) {
            try {
                returnValue = Double.parseDouble((String)obj);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return returnValue;
    }

    public boolean getAsBool(String key) {
        return this.getAsBool(key, false);
    }

    public boolean getAsBool(String key, boolean defaultValue) {
        Object obj = this.get(key);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return defaultValue;
    }

    public List<String> getAsStringList(String key) {
        List list;
        Object obj = this.get(key);
        LinkedList<String> returnValue = new LinkedList<String>();
        if (obj == null) {
            return returnValue;
        }
        if (obj instanceof List && !(list = (List)obj).isEmpty()) {
            for (Object element : list) {
                if (!(element instanceof String)) continue;
                returnValue.add((String)element);
            }
        }
        if (obj instanceof String) {
            returnValue.add(obj.toString());
        }
        return returnValue;
    }

    public Material getAsMaterial(String key) {
        return this.getAsMaterial(key, null);
    }

    public Material getAsMaterial(String key, Material defaultValue) {
        Object obj = this.get(key);
        Material returnValue = defaultValue;
        if (obj == null) {
            return returnValue;
        }
        if (obj instanceof Material) {
            returnValue = (Material)obj;
        }
        if (obj instanceof String) {
            returnValue = Material.matchMaterial((String)((String)obj));
        }
        if (obj instanceof Integer) {
            returnValue = Material.getMaterial((int)((Integer)obj));
        }
        return returnValue == null ? defaultValue : returnValue;
    }

    public ParticleEffects getAsParticle(String key) {
        return this.getAsParticle(key, null);
    }

    public ParticleEffects getAsParticle(String key, ParticleEffects defaultValue) {
        Object obj = this.get(key);
        if (obj instanceof String) {
            String stringParticle = (String)obj;
            if ("null".equalsIgnoreCase(stringParticle) || "none".equalsIgnoreCase(stringParticle) || stringParticle == null) {
                return null;
            }
            ParticleEffects realParticle = defaultValue;
            try {
                ParticleEffects[] particleEffectsArray = ParticleEffects.values();
                int n = particleEffectsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ParticleEffects effect = particleEffectsArray[n2];
                    if (effect.asMirror() != null && effect.asMirror().getPacketArg().equals(stringParticle)) {
                        realParticle = effect;
                    }
                    ++n2;
                }
                if (realParticle == null) {
                    realParticle = ParticleEffects.valueOf(stringParticle.toUpperCase());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (realParticle == null) {
                realParticle = ParticleEffects.FIREWORKS_SPARK;
            }
            return realParticle;
        }
        return defaultValue;
    }

    public ParticleContainer getAsParticleContainer(String key) {
        return this.getAsParticleContainer(key, null);
    }

    public ParticleContainer getAsParticleContainer(String key, ParticleContainer defaultValue) {
        Object obj = this.get(key);
        if (obj instanceof String) {
            ParticleContainer container = ParticleContainer.generate(obj.toString());
            return container == null ? defaultValue : container;
        }
        return defaultValue;
    }

    public TargetType getAsTargetType(String key) {
        return this.getAsTargetType(key, TargetType.ALL);
    }

    public TargetType getAsTargetType(String key, TargetType defaultValue) {
        Object obj = this.get(key);
        if (obj instanceof String) {
            String stringTarget = (String)obj;
            if ((stringTarget = stringTarget.toLowerCase()).startsWith("ally")) {
                return TargetType.FRIEND;
            }
            if (stringTarget.startsWith("alli")) {
                return TargetType.FRIEND;
            }
            if (stringTarget.startsWith("fr")) {
                return TargetType.FRIEND;
            }
            if (stringTarget.startsWith("a")) {
                return TargetType.ALL;
            }
            if (stringTarget.startsWith("e")) {
                return TargetType.ENEMY;
            }
            if (stringTarget.startsWith("fr")) {
                return TargetType.ENEMY;
            }
            return TargetType.ALL;
        }
        return defaultValue;
    }

    public PotionEffectType getAsPotionEffectType(String key) {
        return this.getAsPotionEffectType(key, null);
    }

    public PotionEffectType getAsPotionEffectType(String key, PotionEffectType defaultValue) {
        Object obj = this.get(key);
        if (obj instanceof PotionEffectType) {
            return (PotionEffectType)obj;
        }
        if (obj instanceof String) {
            String potionString = (String)obj;
            return PotionEffectType.getByName((String)potionString);
        }
        if (obj instanceof Integer) {
            int potionNumber = (Integer)obj;
            return PotionEffectType.getById((int)potionNumber);
        }
        return defaultValue;
    }

    @Override
    public Object get(Object key) {
        return super.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return super.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }
}

