/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.util.traitutil;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.RemoveSuperConfigField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class TraitConfigParser {
    public static void configureTraitFromYAML(YamlConfiguration config, String traitPath, Trait trait) throws TraitConfigurationFailedException {
        TraitConfiguration configurationMap = new TraitConfiguration(config);
        String traitHolderName = "UNKNOWN";
        if (!trait.getTraitHolders().isEmpty()) {
            traitHolderName = trait.getTraitHolders().iterator().next().getDisplayName();
        }
        try {
            ConfigurationSection traitConfig = config.getConfigurationSection(traitPath);
            for (String pathEntry : traitConfig.getKeys(true)) {
                Object value = traitConfig.get(pathEntry);
                if (value == null) continue;
                configurationMap.put(pathEntry, value);
            }
            List<TraitConfigurationField> annotationList = TraitConfigParser.getAllTraitConfigFieldsOfTrait(trait);
            List<RemoveSuperConfigField> removedFields = TraitConfigParser.getAllTraitRemovedFieldsOfTrait(trait);
            for (TraitConfigurationField field : annotationList) {
                boolean optional = field.optional();
                boolean isPresent = configurationMap.containsKey(field.fieldName());
                boolean isRemovedField = false;
                for (RemoveSuperConfigField removedField : removedFields) {
                    if (!removedField.name().equalsIgnoreCase(field.fieldName())) continue;
                    isRemovedField = true;
                    break;
                }
                if (optional && !isPresent || isRemovedField) continue;
                if (!optional && !isPresent) {
                    throw new TraitConfigurationFailedException("Field: '" + traitPath + "." + field.fieldName() + "' not found in Config for Trait: " + trait.getName());
                }
                Class<?> classToExpect = field.classToExpect();
                Object toCheck = configurationMap.get(field.fieldName());
                if (toCheck == null) {
                    throw new TraitConfigurationFailedException("Field: '" + traitPath + "." + field.fieldName() + "' not found in Config for Trait: " + trait.getName() + " in Holder: " + traitHolderName + ". Wanted a " + classToExpect.getCanonicalName() + " But found NOTHING.");
                }
                if (classToExpect == Integer.class) {
                    try {
                        if (toCheck instanceof Integer) continue;
                        int value = Integer.parseInt(toCheck.toString());
                        configurationMap.put(field.fieldName(), (Object)value);
                        continue;
                    }
                    catch (NumberFormatException exp) {
                        throw new TraitConfigurationFailedException("Field: '" + traitPath + "." + field.fieldName() + "' not found in Config for Trait: " + trait.getName() + " in Holder: " + traitHolderName + ". Found a " + toCheck.getClass().getCanonicalName() + " but wanted a " + classToExpect.getCanonicalName());
                    }
                }
                if (classToExpect == String.class) {
                    try {
                        String value = YAMLConfigExtended.replaceUmlauts(toCheck.toString());
                        configurationMap.put(field.fieldName(), (Object)value);
                        continue;
                    }
                    catch (Exception exp) {
                        throw new TraitConfigurationFailedException("Field: '" + traitPath + "." + field.fieldName() + "' not found in Config for Trait: " + trait.getName() + " in Holder: " + traitHolderName + ". Found a " + toCheck.getClass().getCanonicalName() + " but wanted a " + classToExpect.getCanonicalName());
                    }
                }
                if (classToExpect == Double.class) {
                    try {
                        if (toCheck instanceof Double) continue;
                        if (toCheck instanceof Integer) {
                            configurationMap.put(field.fieldName(), (Object)((Integer)toCheck));
                            continue;
                        }
                        double value = Double.MIN_VALUE;
                        try {
                            value = Double.parseDouble(toCheck.toString());
                        }
                        catch (NumberFormatException exp) {
                            value = Integer.parseInt(toCheck.toString());
                        }
                        configurationMap.put(field.fieldName(), (Object)value);
                        continue;
                    }
                    catch (NumberFormatException exp) {
                        throw new TraitConfigurationFailedException("Field: '" + traitPath + "." + field.fieldName() + "' not found in Config for Trait: " + trait.getName() + " in Holder: " + traitHolderName + ". Found a " + toCheck.getClass().getCanonicalName() + " but wanted a " + classToExpect.getCanonicalName());
                    }
                }
                if (classToExpect == Boolean.class) {
                    try {
                        if (toCheck instanceof Boolean) continue;
                        boolean value = Boolean.parseBoolean(toCheck.toString());
                        configurationMap.put(field.fieldName(), (Object)value);
                        continue;
                    }
                    catch (NumberFormatException exp) {
                        throw new TraitConfigurationFailedException("Field: '" + traitPath + "." + field.fieldName() + "' not found in Config for Trait: " + trait.getName() + " in Holder: " + traitHolderName + ". Found a " + toCheck.getClass().getCanonicalName() + " but wanted a " + classToExpect.getCanonicalName());
                    }
                }
                if (classToExpect == List.class) {
                    try {
                        if (toCheck instanceof List) continue;
                        List<String> stringList = Arrays.asList(toCheck.toString().replaceAll(" ", "").split(","));
                        int i = 0;
                        while (i < stringList.size()) {
                            stringList.set(i, YAMLConfigExtended.replaceUmlauts(stringList.get(i)));
                            ++i;
                        }
                        configurationMap.put(field.fieldName(), (Object)stringList);
                        continue;
                    }
                    catch (NumberFormatException exp) {
                        throw new TraitConfigurationFailedException("Field: '" + traitPath + "." + field.fieldName() + "' not found in Config for Trait: " + trait.getName() + " in Holder: " + traitHolderName + ". Found a " + toCheck.getClass().getCanonicalName() + " but wanted a " + classToExpect.getCanonicalName());
                    }
                }
                if (classToExpect == Material.class) {
                    try {
                        if (toCheck instanceof Material) continue;
                        Material mat = null;
                        if (toCheck instanceof Integer) {
                            int value = (Integer)toCheck;
                            mat = Material.getMaterial((int)value);
                        } else {
                            String value = toCheck.toString();
                            try {
                                int matID = Integer.parseInt(value);
                                mat = Material.getMaterial((int)matID);
                            }
                            catch (NumberFormatException matID) {
                                // empty catch block
                            }
                            if (mat == null) {
                                try {
                                    mat = Material.valueOf((String)value);
                                }
                                catch (IllegalArgumentException exp) {
                                    throw new NumberFormatException();
                                }
                            }
                        }
                        if (mat == null) {
                            throw new NumberFormatException();
                        }
                        configurationMap.put(field.fieldName(), (Object)mat);
                        continue;
                    }
                    catch (NumberFormatException exp) {
                        throw new TraitConfigurationFailedException("Field: '" + traitPath + "." + field.fieldName() + "' not found in Config for Trait: " + trait.getName() + " in Holder: " + traitHolderName + ". Found a " + toCheck.getClass().getCanonicalName() + " but wanted a " + classToExpect.getCanonicalName());
                    }
                }
                if (classToExpect.isAssignableFrom(toCheck.getClass())) {
                    configurationMap.put(field.fieldName(), classToExpect.cast(toCheck));
                    continue;
                }
                throw new TraitConfigurationFailedException("Field: '" + traitPath + "." + field.fieldName() + "' not found in Config for Trait: " + trait.getName() + " in Holder: " + traitHolderName + ". Found a " + toCheck.getClass().getCanonicalName() + " but wanted a " + classToExpect.getCanonicalName());
            }
            try {
                trait.setConfiguration(configurationMap);
            }
            catch (TraitConfigurationFailedException exp) {
                throw exp;
            }
            catch (Exception exp) {
                if (RacesAndClasses.getPlugin().getConfigManager().getGeneralConfig().isConfig_enableDebugOutputs()) {
                    RacesAndClasses.getPlugin().logStackTrace("Configuring Trait failed: " + trait.getDisplayName() + ". Error in logs.", exp);
                }
                throw new TraitConfigurationFailedException("Configuration of: " + trait.getDisplayName() + " of: " + traitHolderName + " Failed. Check your Config! There seems to be a wrong / unset value! Check the Documentation for Value references.");
            }
        }
        catch (TraitConfigurationFailedException exp) {
            throw exp;
        }
        catch (NullPointerException exp) {
            RacesAndClasses.getPlugin().getDebugLogger().logStackTrace(exp);
            throw new TraitConfigurationFailedException("Got a Nullpointer! Please report. Writing error to Error.log. Error in: " + trait.getName());
        }
        catch (SecurityException e) {
            throw new TraitConfigurationFailedException("No Annotation found in Trait: " + trait.getName());
        }
        catch (NumberFormatException exp) {
            throw new TraitConfigurationFailedException("A number could not be read correct at: " + trait.getName());
        }
        catch (Exception exp) {
            throw new TraitConfigurationFailedException("An unknown Exception has occured at Trait: " + trait.getName() + ". Exception: " + exp.getLocalizedMessage());
        }
    }

    public static List<TraitConfigurationField> getAllTraitConfigFieldsOfTrait(Class<? extends Trait> traitClass) {
        LinkedList<TraitConfigurationField> annotationList = new LinkedList<TraitConfigurationField>();
        Class<? extends Trait> classTocheck = traitClass;
        while (classTocheck != null && classTocheck != Trait.class) {
            try {
                try {
                    Method method = classTocheck.getMethod("setConfiguration", TraitConfiguration.class);
                    if (method == null || !method.isAnnotationPresent(TraitConfigurationNeeded.class)) {
                        throw new NoSuchMethodException();
                    }
                    TraitConfigurationNeeded neededConfig = method.getAnnotation(TraitConfigurationNeeded.class);
                    if (neededConfig != null) {
                        Collections.addAll(annotationList, neededConfig.fields());
                    }
                }
                catch (NoSuchMethodException exp) {
                    classTocheck = classTocheck.getSuperclass();
                    continue;
                }
            }
            catch (Throwable throwable) {
                classTocheck = classTocheck.getSuperclass();
                throw throwable;
            }
            classTocheck = classTocheck.getSuperclass();
        }
        return annotationList;
    }

    public static List<RemoveSuperConfigField> getAllTraitRemovedFieldsOfTrait(Class<? extends Trait> traitClass) {
        LinkedList<RemoveSuperConfigField> annotationList = new LinkedList<RemoveSuperConfigField>();
        Class<? extends Trait> classTocheck = traitClass;
        while (classTocheck != null && classTocheck != Trait.class) {
            try {
                try {
                    Method method = classTocheck.getMethod("setConfiguration", TraitConfiguration.class);
                    if (method == null || !method.isAnnotationPresent(TraitConfigurationNeeded.class)) {
                        throw new NoSuchMethodException();
                    }
                    TraitConfigurationNeeded neededConfig = method.getAnnotation(TraitConfigurationNeeded.class);
                    if (neededConfig != null) {
                        Collections.addAll(annotationList, neededConfig.removedFields());
                    }
                }
                catch (NoSuchMethodException exp) {
                    classTocheck = classTocheck.getSuperclass();
                    continue;
                }
            }
            catch (Throwable throwable) {
                classTocheck = classTocheck.getSuperclass();
                throw throwable;
            }
            classTocheck = classTocheck.getSuperclass();
        }
        return annotationList;
    }

    public static List<TraitConfigurationField> getAllTraitConfigFieldsOfTrait(Trait trait) {
        return TraitConfigParser.getAllTraitConfigFieldsOfTrait(trait.getClass());
    }

    public static List<RemoveSuperConfigField> getAllTraitRemovedFieldsOfTrait(Trait trait) {
        return TraitConfigParser.getAllTraitRemovedFieldsOfTrait(trait.getClass());
    }
}

