/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.util.traitutil;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.util.RaC.file.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class DefaultTraitCopy {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void copyDefaultTraits() {
        RacesAndClasses plugin = RacesAndClasses.getPlugin();
        try {
            String destDirPath = String.valueOf(plugin.getDataFolder().getAbsolutePath()) + File.separator + "traits" + File.separator;
            String jarFilePath = new File(DefaultTraitCopy.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getAbsolutePath();
            DefaultTraitCopy.copy(jarFilePath, destDirPath);
        }
        catch (Exception exp) {
            plugin.getDebugLogger().logError("Could not copy Default traits!");
            plugin.getDebugLogger().logStackTrace(exp);
        }
    }

    private static void copy(String jarFilePath, String destDir) throws IOException {
        try (JarFile jar = new JarFile(jarFilePath);){
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry file = enumeration.nextElement();
                String fileName = file.getName();
                if (!fileName.contains("defaultTraits")) continue;
                File destinationFile = new File(String.valueOf(destDir) + File.separator + file.getName());
                if (file.isDirectory()) {
                    destinationFile.mkdirs();
                    continue;
                }
                if (!fileName.endsWith(".jar")) continue;
                InputStream inputStream = jar.getInputStream(file);
                FileOutputStream outputStream = new FileOutputStream(destinationFile);
                DefaultTraitCopy.copyLarge(inputStream, outputStream);
                try {
                    outputStream.close();
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void removeOldDefaultTraits() {
        RacesAndClasses plugin = RacesAndClasses.getPlugin();
        File oldTraitsDir = new File(plugin.getDataFolder(), "traits");
        FileUtils.deleteFileRecursivly(oldTraitsDir);
    }
}

