/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.util.permissions;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.util.permissions.PermissionChecker;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;

public class VaultHook
extends Permission
implements Listener {
    private Permission hooked;
    private final RacesAndClasses plugin;
    private final List<PermissionChecker> permChecker = new LinkedList<PermissionChecker>();

    protected VaultHook(RacesAndClasses plugin) {
        this.plugin = plugin;
        ServicesManager sm = Bukkit.getServicesManager();
        Permission perms = (Permission)sm.getRegistration(Permission.class).getProvider();
        if (perms == null) {
            this.getVaultRegsterLater();
        } else {
            this.hooked = perms;
            sm.unregister((Object)perms);
        }
        sm.register(Permission.class, (Object)this, (Plugin)plugin, ServicePriority.Highest);
    }

    @EventHandler
    public void vaultStarted(PluginEnableEvent event) {
        if (event.getPlugin().getName().equalsIgnoreCase("Vault")) {
            this.getVaultRegister();
        }
    }

    private void getVaultRegister() {
        if (this.hooked != null) {
            return;
        }
        ServicesManager sm = Bukkit.getServicesManager();
        Collection perms = sm.getRegistrations(Permission.class);
        Permission toSet = null;
        for (RegisteredServiceProvider toObserve : perms) {
            if (toObserve.getProvider() == this) continue;
            toSet = (Permission)toObserve.getProvider();
            break;
        }
        if (this.hooked != null && toSet != null) {
            this.hooked = toSet;
        }
    }

    private void getVaultRegsterLater() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                VaultHook.this.getVaultRegister();
            }
        }, 1L);
    }

    public void shutDown() {
        ServicesManager sm = Bukkit.getServicesManager();
        sm.unregister((Object)this);
        sm.register(Permission.class, (Object)this, Bukkit.getPluginManager().getPlugin("Vault"), ServicePriority.Highest);
    }

    public String[] getGroups() {
        if (this.hooked == null || !this.hooked.hasGroupSupport()) {
            return new String[0];
        }
        return this.hooked.getGroups();
    }

    public String getName() {
        if (this.hooked == null || !this.hooked.hasGroupSupport()) {
            return "";
        }
        return this.hooked.getName();
    }

    public String[] getPlayerGroups(String world, String playerName) {
        if (this.hooked == null || !this.hooked.hasGroupSupport()) {
            return new String[0];
        }
        return this.hooked.getPlayerGroups(world, playerName);
    }

    public String getPrimaryGroup(String arg0, String arg1) {
        if (this.hooked == null || !this.hooked.hasGroupSupport()) {
            return "";
        }
        return this.hooked.getPrimaryGroup(arg0, arg1);
    }

    public boolean groupAdd(String arg0, String arg1, String arg2) {
        if (this.hooked == null || !this.hooked.hasGroupSupport()) {
            return false;
        }
        return this.hooked.groupAdd(arg0, arg1, arg2);
    }

    public boolean groupHas(String arg0, String arg1, String arg2) {
        if (this.hooked == null || !this.hooked.hasGroupSupport()) {
            return false;
        }
        return this.hooked.groupHas(arg0, arg1, arg2);
    }

    public boolean groupRemove(String arg0, String arg1, String arg2) {
        if (this.hooked == null || !this.hooked.hasGroupSupport()) {
            return false;
        }
        return this.hooked.groupRemove(arg0, arg1, arg2);
    }

    public boolean hasGroupSupport() {
        if (this.hooked == null) {
            return false;
        }
        return this.hooked.hasGroupSupport();
    }

    public boolean hasSuperPermsCompat() {
        if (this.hooked == null) {
            return false;
        }
        return this.hooked.hasSuperPermsCompat();
    }

    public boolean isEnabled() {
        if (this.hooked == null) {
            return false;
        }
        return this.hooked.isEnabled();
    }

    public boolean playerAdd(String arg0, String arg1, String arg2) {
        if (this.hooked == null || !this.hooked.hasGroupSupport()) {
            return false;
        }
        return this.hooked.playerAdd(arg0, arg1, arg2);
    }

    public boolean playerAddGroup(String arg0, String arg1, String arg2) {
        if (this.hooked == null || !this.hooked.hasGroupSupport()) {
            return false;
        }
        return this.hooked.playerAddGroup(arg0, arg1, arg2);
    }

    public boolean playerHas(String player, String world, String permission) {
        if (this.hooked == null) {
            return false;
        }
        for (PermissionChecker checker : this.permChecker) {
            PermissionChecker.PermState state = checker.checkPermissions(player, world, permission);
            if (state == PermissionChecker.PermState.FORCE_PERMISE) {
                return true;
            }
            if (state != PermissionChecker.PermState.FORCE_DECLINE) continue;
            return false;
        }
        return this.hooked.playerHas(player, world, permission);
    }

    public boolean playerInGroup(String arg0, String arg1, String arg2) {
        if (this.hooked == null || !this.hooked.hasGroupSupport()) {
            return false;
        }
        return this.hooked.playerInGroup(arg0, arg1, arg2);
    }

    public boolean playerRemove(String arg0, String arg1, String arg2) {
        if (this.hooked == null) {
            return false;
        }
        return this.hooked.playerRemove(arg0, arg1, arg2);
    }

    public boolean playerRemoveGroup(String arg0, String arg1, String arg2) {
        if (this.hooked == null || !this.hooked.hasGroupSupport()) {
            return false;
        }
        return this.hooked.playerRemoveGroup(arg0, arg1, arg2);
    }

    public void registerPermissionChecker(PermissionChecker checker) {
        if (!this.permChecker.contains(checker)) {
            this.permChecker.add(checker);
        }
    }

    public void unregisterPermissionChecker(PermissionChecker checker) {
        if (this.permChecker.contains(checker)) {
            this.permChecker.remove(checker);
        }
    }
}

