/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.util.items;

import de.tobiyas.util.RaC.formating.ParseUtils;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class WandItem {
    private final Material material;
    private final short damage;
    private final String itemName;
    private final String loreLine;

    public WandItem(Material material, short damage, String itemName, String loreLine) {
        this.material = material;
        this.damage = damage;
        this.itemName = itemName == null ? "" : ChatColor.translateAlternateColorCodes((char)'&', (String)itemName);
        this.loreLine = loreLine == null ? "" : ChatColor.translateAlternateColorCodes((char)'&', (String)loreLine);
    }

    public Material getMaterial() {
        return this.material;
    }

    public short getDamage() {
        return this.damage;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getLoreLine() {
        return this.loreLine;
    }

    public ItemStack generateItem() {
        ItemStack item = new ItemStack(this.material);
        if (this.damage >= 0) {
            item.setDurability(this.damage);
        }
        if (this.itemName.isEmpty() && this.loreLine.isEmpty()) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        meta.setDisplayName(this.itemName);
        meta.setLore(Arrays.asList(this.loreLine));
        item.setItemMeta(meta);
        return item;
    }

    public boolean isItem(ItemStack item) {
        String name;
        if (item == null) {
            return false;
        }
        if (this.material != item.getType()) {
            return false;
        }
        if (this.damage >= 0 && item.getDurability() != this.damage) {
            return false;
        }
        if (this.itemName.isEmpty() && this.loreLine.isEmpty()) {
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        String string = name = meta.hasDisplayName() ? meta.getDisplayName() : "";
        if (!name.equals(this.itemName)) {
            return false;
        }
        if (!this.loreLine.isEmpty() && !meta.hasLore()) {
            return false;
        }
        boolean found = false;
        for (String line : meta.getLore()) {
            if (!this.loreLine.equals(line)) continue;
            found = true;
        }
        return found;
    }

    public static WandItem generateFrom(String line) {
        if (line == null || line.isEmpty()) {
            return null;
        }
        String[] split = line.split("##");
        if (split.length == 0 || split[0].isEmpty()) {
            return null;
        }
        Material material = ParseUtils.parseMaterial(split, 0, null);
        if (material == null) {
            return null;
        }
        short damage = ParseUtils.parseShort(split, 1, (short)-1);
        String name = ParseUtils.parseString(split, 2, "");
        String displayLine = ParseUtils.parseString(split, 3, "");
        return new WandItem(material, damage, name, displayLine);
    }
}

