/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.util.items;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemUtils {
    public static ItemQuality getItemValue(ItemStack stack) {
        if (stack == null) {
            return ItemQuality.None;
        }
        Material type = stack.getType();
        for (ItemQuality quality : ItemQuality.values()) {
            if (!quality.getMats().contains(type)) continue;
            return quality;
        }
        return ItemQuality.None;
    }

    public static ArmorSlot getItemSlotEquiping(ItemStack item) {
        if (item == null) {
            return ArmorSlot.NONE;
        }
        switch (item.getType()) {
            case LEATHER_HELMET: 
            case CHAINMAIL_HELMET: 
            case IRON_HELMET: 
            case DIAMOND_HELMET: 
            case GOLD_HELMET: {
                return ArmorSlot.HELMET;
            }
            case LEATHER_CHESTPLATE: 
            case CHAINMAIL_CHESTPLATE: 
            case IRON_CHESTPLATE: 
            case DIAMOND_CHESTPLATE: 
            case GOLD_CHESTPLATE: {
                return ArmorSlot.CHESTPLATE;
            }
            case LEATHER_LEGGINGS: 
            case CHAINMAIL_LEGGINGS: 
            case IRON_LEGGINGS: 
            case DIAMOND_LEGGINGS: 
            case GOLD_LEGGINGS: {
                return ArmorSlot.LEGGINGS;
            }
            case LEATHER_BOOTS: 
            case CHAINMAIL_BOOTS: 
            case IRON_BOOTS: 
            case DIAMOND_BOOTS: 
            case GOLD_BOOTS: {
                return ArmorSlot.BOOTS;
            }
        }
        return ArmorSlot.NONE;
    }

    public static ItemStack getItemInArmorSlotOfPlayer(Player player, ArmorSlot slot) {
        if (slot == null) {
            return null;
        }
        switch (slot) {
            case BOOTS: {
                return player.getInventory().getBoots();
            }
            case CHESTPLATE: {
                return player.getInventory().getChestplate();
            }
            case HELMET: {
                return player.getInventory().getHelmet();
            }
            case LEGGINGS: {
                return player.getInventory().getLeggings();
            }
        }
        return null;
    }

    public static enum ArmorSlot {
        HELMET,
        CHESTPLATE,
        LEGGINGS,
        BOOTS,
        NONE;

    }

    public static class ItemQuality {
        public static final ItemQuality None = new ItemQuality("none");
        public static final ItemQuality Leather = new ItemQuality("leather", new Material[]{Material.LEATHER_BOOTS, Material.LEATHER_LEGGINGS, Material.LEATHER_CHESTPLATE, Material.LEATHER_HELMET});
        public static final ItemQuality Iron = new ItemQuality("iron", new Material[]{Material.IRON_BOOTS, Material.IRON_LEGGINGS, Material.IRON_CHESTPLATE, Material.IRON_HELMET});
        public static final ItemQuality Gold = new ItemQuality("gold", new Material[]{Material.GOLD_BOOTS, Material.GOLD_LEGGINGS, Material.GOLD_CHESTPLATE, Material.GOLD_HELMET});
        public static final ItemQuality Diamond = new ItemQuality("diamond", new Material[]{Material.DIAMOND_BOOTS, Material.DIAMOND_LEGGINGS, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_HELMET});
        public static final ItemQuality Chain = new ItemQuality("chain", new Material[]{Material.CHAINMAIL_BOOTS, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_HELMET});
        private static final List<ItemQuality> allValues = new LinkedList<ItemQuality>();
        private String name;
        private final Collection<Material> mats;

        static {
            allValues.add(None);
            allValues.add(Leather);
            allValues.add(Iron);
            allValues.add(Gold);
            allValues.add(Diamond);
            allValues.add(Chain);
        }

        private ItemQuality(String name) {
            this(name, new Material[0]);
        }

        private ItemQuality(String name, Material[] materials) {
            this(name, Arrays.asList(materials));
        }

        private ItemQuality(String name, Collection<Material> materials) {
            this.name = name;
            this.mats = materials;
        }

        public String getName() {
            return this.name;
        }

        public Collection<Material> getMats() {
            return new HashSet<Material>(this.mats);
        }

        public static Collection<ItemQuality> values() {
            return new HashSet<ItemQuality>(allValues);
        }

        public static void reparse(Map<String, String> qualityMap) {
            allValues.clear();
            for (Map.Entry<String, String> entry : qualityMap.entrySet()) {
                String key = entry.getKey().toLowerCase();
                String toParse = entry.getValue();
                String[] vals = toParse.split(Pattern.quote(","));
                HashSet<Material> mats = new HashSet<Material>();
                if (vals != null && vals.length != 0) {
                    String[] stringArray = vals;
                    int n = vals.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String val = stringArray[n2];
                        Material mat = Material.matchMaterial((String)val);
                        if (mat != null) {
                            mats.add(mat);
                        }
                        ++n2;
                    }
                }
                if (mats.size() <= 0) continue;
                allValues.add(new ItemQuality(key, mats));
            }
            allValues.add(None);
        }

        public static void set(Map<String, Set<Material>> toSet) {
            allValues.clear();
            for (Map.Entry<String, Set<Material>> entry : toSet.entrySet()) {
                ItemQuality quality = new ItemQuality(entry.getKey(), (Collection<Material>)entry.getValue());
                allValues.add(quality);
            }
            allValues.add(None);
        }

        public static Collection<ItemQuality> parse(String armorString) {
            HashSet<ItemQuality> set = new HashSet<ItemQuality>();
            if (armorString == null || armorString.isEmpty()) {
                return set;
            }
            if (armorString.equalsIgnoreCase("all")) {
                return ItemQuality.values();
            }
            String[] parts = armorString.split(Pattern.quote(","));
            if (parts != null && parts.length > 0) {
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    ItemQuality quality = ItemQuality.parseSingle(part);
                    if (quality != null) {
                        set.add(quality);
                    }
                    ++n2;
                }
            }
            return set;
        }

        private static ItemQuality parseSingle(String key) {
            key = key.toLowerCase();
            for (ItemQuality quality : allValues) {
                if (!key.equals(quality.getName())) continue;
                return quality;
            }
            return null;
        }

        public static void loadDefault() {
            allValues.clear();
            allValues.add(Chain);
            allValues.add(Diamond);
            allValues.add(Gold);
            allValues.add(Iron);
            allValues.add(Leather);
            allValues.add(None);
        }
    }
}

