/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.util.items;

import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemMetaUtils {
    public static void setDisplayNameOfItem(ItemStack item, String newDisplayName) {
        if (newDisplayName.length() > 32) {
            newDisplayName = newDisplayName.substring(0, 32);
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(newDisplayName);
        item.setItemMeta(meta);
    }

    public static void addStringToLore(ItemStack item, String toAdd) {
        ItemMeta meta = item.getItemMeta();
        LinkedList<String> lore = null;
        lore = meta.hasLore() ? meta.getLore() : new LinkedList<String>();
        lore.addAll(ItemMetaUtils.formatToLore(toAdd));
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public static List<String> formatToLore(String unformated) {
        String[] words = unformated.split(" ");
        LinkedList<String> lore = new LinkedList<String>();
        String currentLine = ChatColor.YELLOW + " -" + words[0];
        int i = 1;
        while (i < words.length) {
            String currentWord = words[i];
            if (currentLine.length() + words.length + 1 > 29) {
                lore.add(currentLine);
                currentLine = ChatColor.YELLOW + "  " + currentWord;
            } else {
                currentLine = String.valueOf(currentLine) + " " + currentWord;
            }
            ++i;
        }
        if (currentLine.length() > 0) {
            lore.add(currentLine);
        }
        return lore;
    }

    public static void replaceLoreWith(ItemStack item, String newLore) {
        List<String> newLoreList = ItemMetaUtils.formatToLore(newLore);
        ItemMeta meta = item.getItemMeta();
        meta.setLore(newLoreList);
        item.setItemMeta(meta);
    }

    public static void removeLore(ItemStack item) {
        LinkedList emptyList = new LinkedList();
        ItemMeta meta = item.getItemMeta();
        meta.setLore(emptyList);
        item.setItemMeta(meta);
    }
}

