/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.util.items;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.util.items.DropContainer;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import java.io.File;
import java.io.IOException;
import org.bukkit.entity.EntityType;

public class CreateDropContainer {
    public static DropContainer loadDropContainer(String path, EntityType type) {
        YAMLConfigExtended config = new YAMLConfigExtended(path).load();
        if (!config.getValidLoad()) {
            return null;
        }
        for (String name : config.getChildren("monster")) {
            String exactName = config.getString("monster." + name + ".type");
            if (!type.name().equalsIgnoreCase(exactName)) continue;
            return CreateDropContainer.generateContainer(config, "monster." + name + ".");
        }
        return null;
    }

    private static DropContainer generateContainer(YAMLConfigExtended config, String pre) {
        int minEXP = config.getInt(String.valueOf(pre) + "expmin", 0);
        int maxEXP = config.getInt(String.valueOf(pre) + "expmax", -1);
        DropContainer container = new DropContainer(minEXP, maxEXP);
        for (String item : config.getChildren(String.valueOf(pre) + "drop")) {
            String extend = config.getString(String.valueOf(pre) + "drop." + item);
            try {
                container.parseString(String.valueOf(item) + ";" + extend);
            }
            catch (Exception e) {
                RacesAndClasses.getPlugin().getDebugLogger().logError("Could not create Item: " + item + " with extention: " + extend + " in type: " + pre);
            }
        }
        return container;
    }

    public static void createAllContainers(String path) {
        if (!CreateDropContainer.createStructure(path)) {
            return;
        }
        YAMLConfigExtended config = new YAMLConfigExtended(path).load();
        if (!config.getValidLoad()) {
            return;
        }
        config.createSection("monster");
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType type = entityTypeArray[n2];
            CreateDropContainer.createContainer(type, config);
            ++n2;
        }
        config.save();
    }

    private static boolean createStructure(String path) {
        File file = new File(path);
        if (!file.exists()) {
            try {
                file.createNewFile();
                return true;
            }
            catch (IOException e) {
                RacesAndClasses.getPlugin().log("Could not create DropRates.yml");
            }
        }
        return false;
    }

    private static void createContainer(EntityType type, YAMLConfigExtended config) {
        switch (type) {
            case CHICKEN: {
                CreateDropContainer.createChickenContainer(config);
                break;
            }
            case COW: {
                CreateDropContainer.createCowContainer(config);
                break;
            }
            case MUSHROOM_COW: {
                CreateDropContainer.createMushroomCowContainer(config);
                break;
            }
            case OCELOT: {
                CreateDropContainer.createOcelotContainer(config);
                break;
            }
            case PIG: {
                CreateDropContainer.createPigContainer(config);
                break;
            }
            case SHEEP: {
                CreateDropContainer.createSheepContainer(config);
                break;
            }
            case SQUID: {
                CreateDropContainer.createSquidContainer(config);
                break;
            }
            case VILLAGER: {
                CreateDropContainer.createVillagerContainer(config);
                break;
            }
            case ENDERMAN: {
                CreateDropContainer.createEndermanContainer(config);
                break;
            }
            case WOLF: {
                CreateDropContainer.createWolfContainer(config);
                break;
            }
            case PIG_ZOMBIE: {
                CreateDropContainer.createZombiePigmanContainer(config);
                break;
            }
            case BLAZE: {
                CreateDropContainer.createBlazeContainer(config);
                break;
            }
            case CAVE_SPIDER: {
                CreateDropContainer.createCavespiderContainer(config);
                break;
            }
            case CREEPER: {
                CreateDropContainer.createCreeperContainer(config);
                break;
            }
            case GHAST: {
                CreateDropContainer.createGhastContainer(config);
                break;
            }
            case MAGMA_CUBE: {
                CreateDropContainer.createMagmacubeContainer(config);
                break;
            }
            case SILVERFISH: {
                CreateDropContainer.createSilverfishContainer(config);
                break;
            }
            case SKELETON: {
                CreateDropContainer.createSkeletonContainer(config);
                break;
            }
            case SLIME: {
                CreateDropContainer.createSlimeContainer(config);
                break;
            }
            case SPIDER: {
                CreateDropContainer.createSpiderContainer(config);
                break;
            }
            case ZOMBIE: {
                CreateDropContainer.createZombieContainer(config);
                break;
            }
            case SNOWMAN: {
                CreateDropContainer.createSnowgolemContainer(config);
                break;
            }
            case IRON_GOLEM: {
                CreateDropContainer.createIrongolemContainer(config);
                break;
            }
            case ENDER_DRAGON: {
                CreateDropContainer.createEnderdragonContainer(config);
                break;
            }
            case GIANT: {
                CreateDropContainer.createGiantContainer(config);
                break;
            }
            case BAT: {
                CreateDropContainer.createBatContainer(config);
                break;
            }
            case WITCH: {
                CreateDropContainer.createWitchContainer(config);
                break;
            }
            case WITHER: {
                CreateDropContainer.createWitherContainer(config);
            }
        }
    }

    private static void createChickenContainer(YAMLConfigExtended config) {
        String pre = "monster.chicken";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.CHICKEN.name());
        config.set(String.valueOf(pre) + ".expmin", 1);
        config.set(String.valueOf(pre) + ".expmax", 3);
    }

    private static void createCowContainer(YAMLConfigExtended config) {
        String pre = "monster.cow";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.COW.name());
        config.set(String.valueOf(pre) + ".expmin", 1);
        config.set(String.valueOf(pre) + ".expmax", 3);
    }

    private static void createMushroomCowContainer(YAMLConfigExtended config) {
        String pre = "monster.mushroomcow";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.MUSHROOM_COW.name());
        config.set(String.valueOf(pre) + ".expmin", 1);
        config.set(String.valueOf(pre) + ".expmax", 3);
    }

    private static void createOcelotContainer(YAMLConfigExtended config) {
        String pre = "monster.ocelot";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.OCELOT.name());
        config.set(String.valueOf(pre) + ".expmin", 1);
        config.set(String.valueOf(pre) + ".expmax", 3);
    }

    private static void createPigContainer(YAMLConfigExtended config) {
        String pre = "monster.pig";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.PIG.name());
        config.set(String.valueOf(pre) + ".expmin", 1);
        config.set(String.valueOf(pre) + ".expmax", 3);
    }

    private static void createSheepContainer(YAMLConfigExtended config) {
        String pre = "monster.sheep";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.SHEEP.name());
        config.set(String.valueOf(pre) + ".expmin", 1);
        config.set(String.valueOf(pre) + ".expmax", 3);
    }

    private static void createSquidContainer(YAMLConfigExtended config) {
        String pre = "monster.squid";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.SQUID.name());
        config.set(String.valueOf(pre) + ".expmin", 1);
        config.set(String.valueOf(pre) + ".expmax", 3);
    }

    private static void createVillagerContainer(YAMLConfigExtended config) {
        String pre = "monster.villager";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.VILLAGER.name());
        config.set(String.valueOf(pre) + ".expmin", 0);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createEndermanContainer(YAMLConfigExtended config) {
        String pre = "monster.enderman";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.ENDERMAN.name());
        config.set(String.valueOf(pre) + ".expmin", 5);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createWolfContainer(YAMLConfigExtended config) {
        String pre = "monster.wolf";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.WOLF.name());
        config.set(String.valueOf(pre) + ".expmin", 1);
        config.set(String.valueOf(pre) + ".expmax", 3);
    }

    private static void createZombiePigmanContainer(YAMLConfigExtended config) {
        String pre = "monster.zombiepigman";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.PIG_ZOMBIE.name());
        config.set(String.valueOf(pre) + ".expmin", 5);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createBlazeContainer(YAMLConfigExtended config) {
        String pre = "monster.blaze";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.BLAZE.name());
        config.set(String.valueOf(pre) + ".expmin", 10);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createCavespiderContainer(YAMLConfigExtended config) {
        String pre = "monster.cavespider";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.CAVE_SPIDER.name());
        config.set(String.valueOf(pre) + ".expmin", 5);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createCreeperContainer(YAMLConfigExtended config) {
        String pre = "monster.creeper";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.CREEPER.name());
        config.set(String.valueOf(pre) + ".expmin", 5);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createGhastContainer(YAMLConfigExtended config) {
        String pre = "monster.ghast";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.GHAST.name());
        config.set(String.valueOf(pre) + ".expmin", 5);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createMagmacubeContainer(YAMLConfigExtended config) {
        String pre = "monster.magmacube";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.MAGMA_CUBE.name());
        config.set(String.valueOf(pre) + ".expmin", 1);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createSilverfishContainer(YAMLConfigExtended config) {
        String pre = "monster.silverfish";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.SILVERFISH.name());
        config.set(String.valueOf(pre) + ".expmin", 5);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createSkeletonContainer(YAMLConfigExtended config) {
        String pre = "monster.skeleton";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.SKELETON.name());
        config.set(String.valueOf(pre) + ".expmin", 5);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createSlimeContainer(YAMLConfigExtended config) {
        String pre = "monster.slime";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.SLIME.name());
        config.set(String.valueOf(pre) + ".expmin", 1);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createSpiderContainer(YAMLConfigExtended config) {
        String pre = "monster.spider";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.SPIDER.name());
        config.set(String.valueOf(pre) + ".expmin", 5);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createZombieContainer(YAMLConfigExtended config) {
        String pre = "monster.zombie";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.ZOMBIE.name());
        config.set(String.valueOf(pre) + ".expmin", 5);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createSnowgolemContainer(YAMLConfigExtended config) {
        String pre = "monster.snowgolem";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.SNOWMAN.name());
        config.set(String.valueOf(pre) + ".expmin", 0);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createIrongolemContainer(YAMLConfigExtended config) {
        String pre = "monster.irongolem";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.IRON_GOLEM.name());
        config.set(String.valueOf(pre) + ".expmin", 0);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createEnderdragonContainer(YAMLConfigExtended config) {
        String pre = "monster.enderdragon";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.ENDER_DRAGON.name());
        config.set(String.valueOf(pre) + ".expmin", 20000);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createGiantContainer(YAMLConfigExtended config) {
        String pre = "monster.giant";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.GIANT.name());
        config.set(String.valueOf(pre) + ".expmin", 5);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createBatContainer(YAMLConfigExtended config) {
        String pre = "monster.bat";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.BAT.name());
        config.set(String.valueOf(pre) + ".expmin", 0);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createWitchContainer(YAMLConfigExtended config) {
        String pre = "monster.witch";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.WITCH.name());
        config.set(String.valueOf(pre) + ".expmin", 5);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }

    private static void createWitherContainer(YAMLConfigExtended config) {
        String pre = "monster.wither";
        config.createSection(pre);
        config.set(String.valueOf(pre) + ".type", EntityType.WITHER.name());
        config.set(String.valueOf(pre) + ".expmin", 50);
        config.set(String.valueOf(pre) + ".expmax", -1);
    }
}

