/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.util.friend;

import de.tobiyas.racesandclasses.APIs.GroupAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.friend.TargetType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class EnemyChecker
implements Listener {
    private static EnemyChecker checker;

    public EnemyChecker() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)RacesAndClasses.getPlugin());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void entityDamage(EntityDamageByEntityEvent event) {
        if (event instanceof FriendDetectEvent) {
            ((FriendDetectEvent)event).realCancle = event.isCancelled();
            event.setCancelled(true);
        }
    }

    public static boolean areAllies(Entity attacker, Entity receiver) {
        Player p2;
        Player p1;
        if (checker == null) {
            checker = new EnemyChecker();
        }
        if (attacker == null || receiver == null) {
            return false;
        }
        if (attacker instanceof Projectile && (attacker = CompatibilityModifier.Shooter.getShooter((Projectile)attacker)) == null) {
            return false;
        }
        if (attacker instanceof Player && receiver instanceof Player && GroupAPI.isInSameGroup(p1 = (Player)attacker, p2 = (Player)receiver)) {
            return true;
        }
        FriendDetectEvent event = new FriendDetectEvent(attacker, receiver);
        RacesAndClasses.getPlugin().fireEventToBukkit((Event)event);
        return event.realCancle;
    }

    public static boolean areEnemies(Entity attacker, Entity receiver) {
        return !EnemyChecker.areAllies(attacker, receiver);
    }

    public static boolean isApplyable(Entity attacker, Entity receiver, TargetType type) {
        switch (type) {
            case ENEMY: {
                return EnemyChecker.areEnemies(attacker, receiver);
            }
            case FRIEND: {
                return EnemyChecker.areAllies(attacker, receiver);
            }
            case ALL: {
                return true;
            }
        }
        return false;
    }

    public static class FriendDetectEvent
    extends EntityDamageByEntityEvent {
        boolean realCancle = false;

        public FriendDetectEvent(Entity damager, Entity damagee) {
            super(damager, damagee, EntityDamageEvent.DamageCause.CUSTOM, 0.1);
        }
    }
}

