/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.eventprocessing.events.entitydamage.EntityHealEvent;
import de.tobiyas.racesandclasses.util.bukkit.versioning.CertainVersionChecker;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.GameMode;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class CompatibilityModifier {

    public static class BukkitPlayer {
        public static boolean isFullyHealed(Player player) {
            if (player == null) {
                return false;
            }
            return Math.abs(BukkitPlayer.safeGetMaxHealth(player) - BukkitPlayer.safeGetHealth(player)) < 0.01;
        }

        public static void safeSetMaxHealth(double maxHealth, Player player) {
            if (maxHealth <= 0.0) {
                return;
            }
            if (player == null) {
                return;
            }
            if (BukkitPlayer.safeGetHealth(player) < maxHealth) {
                BukkitPlayer.safeSetHealth(maxHealth, player);
            }
            if (CertainVersionChecker.isAbove1_6()) {
                try {
                    player.setMaxHealth(maxHealth);
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    Method method = Damageable.class.getMethod("setMaxHealth", Integer.TYPE);
                    int intHealthValue = (int)maxHealth;
                    method.invoke((Object)player, intHealthValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static double safeGetMaxHealth(Player player) {
            if (player == null) {
                return 0.0;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                return player.getMaxHealth();
            }
            try {
                Method method = Damageable.class.getMethod("getMaxHealth", new Class[0]);
                int maxHealth = (Integer)method.invoke((Object)player, new Object[0]);
                return maxHealth;
            }
            catch (Exception exp) {
                return 20.0;
            }
        }

        public static double safeGetHealth(Player player) {
            if (player == null) {
                return 0.0;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                return player.getHealth();
            }
            try {
                Method method = Damageable.class.getMethod("getHealth", new Class[0]);
                int maxHealth = (Integer)method.invoke((Object)player, new Object[0]);
                return maxHealth;
            }
            catch (Exception exp) {
                return 20.0;
            }
        }

        public static void safeSetHealth(double newHealth, Player player) {
            if (player == null) {
                return;
            }
            if (newHealth > BukkitPlayer.safeGetMaxHealth(player)) {
                newHealth = BukkitPlayer.safeGetMaxHealth(player);
            }
            if (CertainVersionChecker.isAbove1_6()) {
                try {
                    player.setHealth(newHealth);
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    Method method = Damageable.class.getMethod("setHealth", Integer.TYPE);
                    int intNewHealth = (int)newHealth;
                    method.invoke((Object)player, intNewHealth);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static void safeDamage(double damage, Player player) {
            if (player == null) {
                return;
            }
            if (player.getGameMode() == GameMode.CREATIVE) {
                return;
            }
            double oldHealth = BukkitPlayer.safeGetHealth(player);
            double newHealth = oldHealth - damage;
            BukkitPlayer.safeSetHealth(newHealth, player);
        }

        public static void safeDamageWithEvent(double damage, Player player) {
            if (player == null) {
                return;
            }
            if (player.getGameMode() == GameMode.CREATIVE) {
                return;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                try {
                    player.damage(damage);
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    Method method = Damageable.class.getMethod("damage", Integer.TYPE);
                    int intNewHealth = (int)damage;
                    method.invoke((Object)player, intNewHealth);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static void safeHeal(double healAmount, Player player) {
            if (player == null) {
                return;
            }
            if (healAmount <= 0.0) {
                return;
            }
            double oldHealth = BukkitPlayer.safeGetHealth(player);
            double newHealth = oldHealth + healAmount;
            BukkitPlayer.safeSetHealth(newHealth, player);
        }
    }

    public static class EntityDamage {
        public static double safeGetDamage(EntityDamageEvent event) {
            if (CertainVersionChecker.isAbove1_6()) {
                return event.getDamage();
            }
            try {
                Method method = EntityDamageEvent.class.getMethod("getDamage", new Class[0]);
                int value = (Integer)method.invoke((Object)event, new Object[0]);
                return value;
            }
            catch (Exception exp) {
                return 1.0;
            }
        }

        public static void safeSetDamage(double damage, EntityDamageEvent event) {
            if (CertainVersionChecker.isAbove1_6()) {
                event.setDamage(damage);
            } else {
                try {
                    Method method = EntityDamageEvent.class.getMethod("setDamage", Integer.TYPE);
                    int intValue = (int)damage;
                    method.invoke((Object)event, intValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static EntityDamageEvent safeCreateEvent(Entity entity, EntityDamageEvent.DamageCause cause, double damage) {
            if (CertainVersionChecker.isAbove1_6()) {
                return new EntityDamageEvent(entity, cause, damage);
            }
            int roundedDamage = Math.round((float)damage);
            return new EntityDamageEvent(entity, cause, (double)roundedDamage);
        }
    }

    public static class EntityDamageByEntity {
        public static EntityDamageByEntityEvent safeCreateEvent(Entity damager, Entity target, EntityDamageEvent.DamageCause cause, double damage) {
            if (CertainVersionChecker.isAbove1_6()) {
                return new EntityDamageByEntityEvent(damager, target, cause, damage);
            }
            try {
                int roundedDamage = Math.round((float)damage);
                return new EntityDamageByEntityEvent(damager, target, cause, (double)roundedDamage);
            }
            catch (Exception exp) {
                return null;
            }
        }
    }

    public static class EntityHeal {
        public static EntityHealEvent safeGenerate(Entity target, double amount, EntityRegainHealthEvent.RegainReason reason) {
            if (target == null) {
                return null;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                return new EntityHealEvent(target, amount, reason);
            }
            int intAmount = (int)amount;
            return new EntityHealEvent(target, intAmount, reason);
        }

        public static void safeSetAmount(EntityHealEvent event, double amount) {
            if (event == null) {
                return;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                event.setAmount(amount);
            } else {
                try {
                    Method method = EntityRegainHealthEvent.class.getMethod("setAmount", Integer.TYPE);
                    int intAmount = (int)amount;
                    method.invoke((Object)event, intAmount);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static double safeGetAmount(EntityHealEvent event) {
            if (event == null) {
                return 0.0;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                return event.getAmount();
            }
            try {
                Method method = EntityRegainHealthEvent.class.getMethod("getAmount", new Class[0]);
                return (Double)method.invoke((Object)event, new Object[0]);
            }
            catch (Exception exp) {
                return 0.0;
            }
        }
    }

    public static class EntityRegainHealth {
        public static void safeSetAmount(EntityRegainHealthEvent event, double amount) {
            if (event == null) {
                return;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                event.setAmount(amount);
            } else {
                try {
                    Method method = EntityRegainHealthEvent.class.getMethod("setAmount", Integer.TYPE);
                    int intAmount = (int)amount;
                    method.invoke((Object)event, intAmount);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static double safeGetAmount(EntityRegainHealthEvent event) {
            if (event == null) {
                return 0.0;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                return event.getAmount();
            }
            try {
                Method method = EntityRegainHealthEvent.class.getMethod("getAmount", new Class[0]);
                return (Double)method.invoke((Object)event, new Object[0]);
            }
            catch (Exception exp) {
                return 0.0;
            }
        }
    }

    public static class LivingEntity {
        public static void safeDamageEntity(org.bukkit.entity.LivingEntity entity, double value) {
            if (entity == null) {
                return;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                entity.damage(value);
            } else {
                int damage = Math.round((float)value);
                try {
                    Method method = org.bukkit.entity.LivingEntity.class.getMethod("damage", Integer.class);
                    method.invoke((Object)entity, damage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static void safeDamageEntityByEntity(org.bukkit.entity.LivingEntity entity, org.bukkit.entity.LivingEntity damager, double value) {
            if (entity == null) {
                return;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                entity.damage(value, (Entity)damager);
            } else {
                int damage = Math.round((float)value);
                try {
                    Method method = org.bukkit.entity.LivingEntity.class.getMethod("damage", Integer.class, Entity.class);
                    method.invoke((Object)entity, damage, damager);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static void safeDamageEntityByEntity(org.bukkit.entity.LivingEntity entity, org.bukkit.entity.LivingEntity damager, double value, EntityDamageEvent.DamageCause cause) {
            if (entity == null) {
                return;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                new DamageEventChangerClass(cause);
                entity.damage(value, (Entity)damager);
            } else {
                int damage = Math.round((float)value);
                try {
                    Method method = org.bukkit.entity.LivingEntity.class.getMethod("damage", Integer.class, Entity.class);
                    method.invoke((Object)entity, damage, damager);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static void safeHealEntity(org.bukkit.entity.LivingEntity entity, double value) {
            if (entity == null) {
                return;
            }
            if (value < 0.0) {
                return;
            }
            double maxHealth = LivingEntity.safeGetEntityMaxHealth(entity);
            double newHealth = LivingEntity.safeGetEntityHealth(entity) + value;
            LivingEntity.safeSetEntityHealth(entity, Math.min(maxHealth, newHealth));
        }

        public static double safeGetEntityHealth(org.bukkit.entity.LivingEntity entity) {
            if (entity == null) {
                return 0.0;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                return entity.getHealth();
            }
            try {
                Method method = org.bukkit.entity.LivingEntity.class.getMethod("getHealth", new Class[0]);
                return (Double)method.invoke((Object)entity, new Object[0]);
            }
            catch (Exception exp) {
                return 0.0;
            }
        }

        public static double safeGetEntityMaxHealth(org.bukkit.entity.LivingEntity entity) {
            if (entity == null) {
                return 0.0;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                return entity.getMaxHealth();
            }
            try {
                Method method = org.bukkit.entity.LivingEntity.class.getMethod("getMaxHealth", new Class[0]);
                return (Double)method.invoke((Object)entity, new Object[0]);
            }
            catch (Exception exp) {
                return 0.0;
            }
        }

        public static void safeSetEntityMaxHealth(org.bukkit.entity.LivingEntity entity, double value) {
            if (entity == null) {
                return;
            }
            double maxHealth = LivingEntity.safeGetEntityMaxHealth(entity);
            if (CertainVersionChecker.isAbove1_6()) {
                entity.setMaxHealth(maxHealth);
            } else {
                try {
                    Method method = org.bukkit.entity.LivingEntity.class.getMethod("setHealth", Integer.class);
                    method.invoke((Object)entity, (int)maxHealth);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public static void safeSetEntityHealth(org.bukkit.entity.LivingEntity entity, double value) {
            if (entity == null) {
                return;
            }
            if (value <= 0.0) {
                return;
            }
            if (CertainVersionChecker.isAbove1_6()) {
                entity.setHealth(value);
            } else {
                try {
                    Method method = org.bukkit.entity.LivingEntity.class.getMethod("setHealth", Integer.class);
                    method.invoke((Object)entity, (int)value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private static class DamageEventChangerClass
        implements Listener {
            private final EntityDamageEvent.DamageCause cause;

            private DamageEventChangerClass(EntityDamageEvent.DamageCause cause) {
                this.cause = cause;
                RacesAndClasses.getPlugin().registerEvents(this);
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void damage(EntityDamageByEntityEvent event) {
                try {
                    Field field = EntityDamageEvent.class.getDeclaredField("cause");
                    field.setAccessible(true);
                    field.set(event, this.cause);
                }
                catch (Throwable exp) {
                    exp.printStackTrace();
                }
                HandlerList.unregisterAll((Listener)this);
            }
        }
    }

    public static class Shooter {
        public static org.bukkit.entity.LivingEntity getShooter(Projectile projectile) {
            if (projectile == null) {
                return null;
            }
            try {
                return (org.bukkit.entity.LivingEntity)projectile.getShooter();
            }
            catch (Throwable throwable) {
                try {
                    Method method = projectile.getClass().getMethod("getShooter", new Class[0]);
                    return (org.bukkit.entity.LivingEntity)method.invoke((Object)projectile, method);
                }
                catch (Throwable throwable2) {
                    return null;
                }
            }
        }
    }
}

