/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.util.bukkit.versioning;

public class BukkitVersion {
    private final int bukkitMainVersion;
    private final int bukkitSubVersion;
    private final int bukkitSubSubVersion;
    private final int revisionMainVersion;
    private final int revisionSubVersion;

    private BukkitVersion() {
        this.bukkitMainVersion = -1;
        this.bukkitSubVersion = -1;
        this.bukkitSubSubVersion = -1;
        this.revisionMainVersion = -1;
        this.revisionSubVersion = -1;
    }

    public BukkitVersion(int bukkitMainVersion, int bukkitSubVersion, int bukkitSubSubVersion, int revisionMainVersion, int revisionSubVersion) {
        this.bukkitMainVersion = bukkitMainVersion;
        this.bukkitSubVersion = bukkitSubVersion;
        this.bukkitSubSubVersion = bukkitSubSubVersion;
        this.revisionMainVersion = revisionMainVersion;
        this.revisionSubVersion = revisionSubVersion;
    }

    public static BukkitVersion empty() {
        return new BukkitVersion();
    }

    public int getBukkitMainVersion() {
        return this.bukkitMainVersion;
    }

    public int getBukkitSubVersion() {
        return this.bukkitSubVersion;
    }

    public int getBukkitSubSubVersion() {
        return this.bukkitSubSubVersion;
    }

    public int getRevisionMainVersion() {
        return this.revisionMainVersion;
    }

    public int getRevisionSubVersion() {
        return this.revisionSubVersion;
    }

    public int getTotalNumber() {
        return this.revisionSubVersion + this.revisionMainVersion * 10 + this.bukkitSubSubVersion * 100 + this.bukkitSubVersion * 1000 + this.bukkitMainVersion * 10000;
    }

    public boolean isGreater(BukkitVersion checkVersion) {
        return this.getTotalNumber() > checkVersion.getTotalNumber();
    }
}

