/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.translation;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.addins.placeholderapisupport.PlaceholderAPISupportManager;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Translator {
    private final String originalText;
    private String modifiedText;
    private RaCPlayer playerReplace;

    public Translator(String originalText) {
        this.originalText = originalText;
        this.modifiedText = originalText;
        this.tryReplaceReTranslation();
        this.decodeColor();
    }

    public void resetToOriginal() {
        this.modifiedText = this.originalText;
    }

    public String build() {
        this.replaceUmlauts();
        return this.modifiedText;
    }

    private void replaceUmlauts() {
        this.modifiedText = this.modifiedText.replace("<o>", "\u00f6").replace("<O>", "\u00d6").replace("<a>", "\u00e4").replace("<A>", "\u00c4").replace("<u>", "\u00fc").replace("<U>", "\u00dc").replace("<ss>", "\u00df");
    }

    public boolean everyParamFilled() {
        return !this.modifiedText.matches("*.%.*%.*");
    }

    public void setReplacePlayer(RaCPlayer player) {
        this.playerReplace = player;
    }

    public Translator replace(Map<String, String> replaceMap) {
        if (this.modifiedText == null || replaceMap == null) {
            return this;
        }
        for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
            String toReplace = entry.getKey();
            String replaceWith = entry.getValue();
            if (toReplace == null || toReplace.isEmpty() || replaceWith == null) continue;
            toReplace = "%" + toReplace.toUpperCase() + "%";
            this.modifiedText = this.modifiedText.replaceAll(toReplace, replaceWith);
        }
        this.replaceToPlayer();
        this.replaceToPlaceholderAPIs();
        return this.decodeColor();
    }

    private void replaceToPlayer() {
        if (this.playerReplace == null) {
            return;
        }
        this.modifiedText = this.modifiedText.replace("%PLAYER%", this.playerReplace.getDisplayName());
        this.modifiedText = this.modifiedText.replace("%PLAYERNAME%", this.playerReplace.getDisplayName());
        if (this.playerReplace.getRace() != null) {
            this.modifiedText = this.modifiedText.replace("%RACE%", this.playerReplace.getRace().getDisplayName());
        }
        if (this.playerReplace.getclass() != null) {
            this.modifiedText = this.modifiedText.replace("%CLASS%", this.playerReplace.getclass().getDisplayName());
        }
        this.modifiedText = this.modifiedText.replace("%LEVEL%", String.valueOf(this.playerReplace.getLevelManager().getCurrentLevel()));
        this.modifiedText = this.modifiedText.replace("%EXP%", String.valueOf(this.playerReplace.getLevelManager().getCurrentExpOfLevel()));
        if (this.playerReplace.isOnline()) {
            Player player = this.playerReplace.getPlayer();
            this.modifiedText = this.modifiedText.replace("%WORLD%", player.getWorld().getName());
        }
    }

    private void replaceToPlaceholderAPIs() {
        if (this.playerReplace == null) {
            return;
        }
        PlaceholderAPISupportManager apiSupport = RacesAndClasses.getPlugin().getAddinManager().getPlaceholderAPISupportManager();
        this.modifiedText = apiSupport.replace(this.playerReplace.getPlayer(), this.modifiedText);
    }

    public Translator replace(String toReplace, String replaceWith) {
        toReplace = "%" + toReplace.toUpperCase() + "%";
        this.modifiedText = this.modifiedText.replaceAll(toReplace, replaceWith);
        return this.decodeColor();
    }

    public String toString() {
        return this.build();
    }

    public Translator tryReplaceReTranslation() {
        Pattern pattern = Pattern.compile("\\@(.*?)\\@");
        Matcher matcher = pattern.matcher(this.modifiedText);
        while (matcher.find()) {
            String found = matcher.group(1);
            Translator translator = LanguageAPI.translateIgnoreError(found).tryReplaceReTranslation();
            this.modifiedText = this.modifiedText.replaceAll("@" + found + "@", translator.build());
        }
        return this.decodeColor();
    }

    public Translator decodeColor() {
        this.modifiedText = ChatColor.translateAlternateColorCodes((char)'&', (String)this.modifiedText);
        return this;
    }
}

