/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.translation;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.translation.TranslationManager;
import de.tobiyas.racesandclasses.translation.Translator;
import de.tobiyas.racesandclasses.translation.exception.TranslationNotFoundException;
import de.tobiyas.util.RaC.config.YAMLConfigExtended;
import de.tobiyas.util.RaC.file.IOUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.configuration.InvalidConfigurationException;

public class DefaultTranslationManager
implements TranslationManager {
    private final RacesAndClasses plugin = RacesAndClasses.getPlugin();
    private String language;
    private List<YAMLConfigExtended> languageConfiguration;
    private final String stdLanguage = "en";
    private final List<YAMLConfigExtended> stdLanguageFiles = Arrays.asList(new YAMLConfigExtended().loadSafeFromString("already_are: '&cYou already are a &d%HOLDER%&c.'\r\nalread_full_mana: '&cYou already have full mana.'\r\nalready_have_class: '&cYou already have a class: &d%CLASS%&c. Use &c/class change&c to change your class.'\r\nalready_have_race: '&cYou already have a race: &d%RACE%&c. Use &c/race change&c to change your race.'\r\narmor: 'Armor'\r\narmor_not_allowed: '&cYou are not allowed to use &c%MATERIAL%&a.'\r\narrow_change: '&aSwitched arrows to: &d%TRAIT_NAME%&a.'\r\nbow_selected_message: '&a You have a &dBOW &ain your hand. Use &dLEFT &aClick to change through your arrows. Current arrow: &d%CURRENT_ARROW% &a.'\r\nbuff_activated: '&a You activated &d%BUFF%&a.'\r\nbuff_timeout: '&a Buff &d%BUFF% &atimedout.'\r\nbuff_used: '&a Buff &d%BUFF% &aused.'\r\nchannel_propertie: 'channelPropertie'\r\nchange_to_same_holder: '&cYou are already a &d%HOLDER%&c.'\r\nclass: 'class'\r\nclass_not_exist: '&cThe class &d%CLASS% &cdoes not exist.'\r\nclass_changed_to: '&cYour Class has been changed to: &d%CLASS%&c.'\r\nclass_changed_to_other: '&aClass of &d%PLAYER%&a changed to: &d%CLASS%&d.'\r\ncooldown_is_ready_again: '&d%TRAIT_NAME% &ais ready again.'\r\ncooldown_is_ready_in: '&cYou still have Cooldown. Ready in &d%TIME%&c.'\r\ndisabled_region: '&cYou may not use any Trait here.'\r\nfailed: '&cfailed'\r\nfood_cancle: '&aEating cancled.'\r\nfood_eat: '&cDo not move, or your eating will be cancled.'\r\nfood_finished: '&cEating finished.'\r\nhealed: '&aYou have been healed.'\r\nhealed_other: '&aYou have healed: &d%PLAYER%&a.'\r\nhealth: 'Health'\r\nhealth_full: 'Your health is full.'\r\nheld_item_not_air: '&aYou may not have an item in your hands.'\r\nholder_selectiongui_header: '&aSelect your &d%HOLDER%&a, %PLAYER%'\r\nholder_not_present: '&cYou have to be a %HOLDER% for this.'\r\nin_restricted_area: '&cYou may not use any Trait here.'\r\nlogin_no_race_selected: '&cYou have not selected a Race. Please select a race using /race select <racename>'\r\nlaunched_something: '&a%NAME% launched.'\r\nlevel_too_low: '&cYour level is too low.'\r\nlevel_up_message: '&aCongratulations, &d%PLAYER%&a. You leveled up to Level &d%LEVEL%&a.'\r\nlevel_up_new_skill_message: '&aYou have learned a new Skill: &d%TRAITNAME%&a.'\r\nmagic_chaneling_failed: '&cChaneling of &d%TRAIT_NAME% &cfailed.'\r\nmagic_change_spells: '&aChanged Spell to: &d%TRAIT_NAME% &aCost: &d%COST% %COST_TYPE%&a.'\r\nmagic_dont_have_enough: '&c You do not have enough &d%COST_TYPE% &cfor &d%TRAIT_NAME% &c.'\r\nmagic_no_spells: '&cYou can not cast any spells.'\r\nmagic_spell_activated: '&d%TRAIT_NAME% &aactivated.'\r\nmagic_spell_deactivated: '&d%TRAIT_NAME% &cdeactivated.'\r\nmana_already_full: '&cYour Mana is already full.'\r\nmana: 'mana'\r\nmember_config_not_found: '&cYour config could not be found. Try relogging or contact an Admin.'\r\nmember_config_changed: '&aThe Attribute &d%ATTRIBUTE%&a has been changed to: &d%VALUE%&a.'\r\nmember_config_attribute_not_found: '&cThe Attribute &d%ATTRIBUTE%&c could not be found.'\r\nneeds_1_arg: 'This command needs 1 argument: %COMMAND%'\r\nnew_value: 'new Value'\r\nno_class_in_list: 'No Classes in the list.'\r\nno_class_on_change: '@no_class_selected@. Use &d/class select &cto select a class.'\r\nno_class_selected_use_info: '&cYou have no class selected. Use &d/class info <class name> &cto inspect a class.'\r\nno_class_selected: '&cYou have no class selected.'\r\nno_class_to_select: '&c You do not have any Classes to select.'\r\nno_find_trait: '&c Could not find this trait.'\r\nno_healthcontainer_found: '&cSomething gone Wrong. No healthcontainer found for you.'\r\nno_message: '&cNo message given.'\r\nnumber_not_readable: '&cNumber could not be read.'\r\nno_race_selected: '&cYou have no race selected.'\r\nno_race_to_select: '&c You do not have any Race to select.'\r\nno_taget_found: '&cNo target found.'\r\nno_traits: '&cNo Traits.'\r\nonly_players: '&cThis command can only be used by Players.'\r\nopen_holder: '&2Opening %HOLDER% Selection....'\r\nopen_traits: '&a Opening Traits of &d%PLAYER%&a.'\r\npassword: 'password'\r\npermission_not_present: '&cYou do not have the Permission to do that.'\r\nplayer_not_exist: '&cPlayer &d%PLAYER%&c does not exist.'\r\nplugin_pre: '&4[RaC]'\r\nquick_slot_item_lore: '&4Throw this item away in the Inventory to remove it.'\r\nquick_slot_selected: '&4Quickslot item recieved in inventory.'\r\nrace: 'race'\r\nrace_not_exist: '&cThe race &d%RACE% &cdoes not exist.'\r\nrace_changed_to: '&cYour Race has been changed to: &d%RACE%&c.'\r\nrace_changed_to_other: '&aRace of &d%PLAYER%&a changed to: &d%RACE%&d.'\r\nrace_spawn_created: '&aRace-Spawn of &d%RACE% &acreated.'\r\nrace_spawn_no_spawnpoint: '&cThe race &d%RACE% &chas no spawnpoint.'\r\nrace_spawn_teleport_success: '&aWelcome to the Race Spawn of &d%RACE%&a.'\r\nreload_message: '&aReload of &dRaces &adone successfully. Time taken: &d %TIME% &ams'\r\nrestrictions_not_met: '&aThe Trait still has cooldown or may not be used here..'\r\nrestrictions_not_met_MinimumLevel: '&cYour level is too low.'\r\nrestrictions_not_met_MaximumLevel: '&cYour level is too hight.'\r\nrestrictions_not_Biomes: '&cCan not be used in this biome'\r\nrestrictions_not_met_Wearing: '&cYou are not wearing the correct clothings.'\r\nrestrictions_not_met_OnlyInWater: '&cCan be used only in water.'\r\nrestrictions_not_met_OnlyInWorld: '&cCan be used only on another world.'\r\nrestrictions_not_met_OnlyOnLand: '&cCan be used only on land.'\r\nrestrictions_not_met_OnlyInLava: '&cCan be used only in lava.'\r\nrestrictions_not_met_OnlyOnSnow: '&cCan be used only on snow.'\r\nrestrictions_not_met_OnlyInNight: '&cCan be used only in night.'\r\nrestrictions_not_met_OnlyOnDay: '&cCan be used only on day.'\r\nrestrictions_not_met_Cooldown: '&cStill has cooldown.'\r\nrestrictions_not_met_AboveLevitation: '&cYour elevation is too low.'\r\nrestrictions_not_met_BelowLevitation: '&cYour elevation is too high.'\r\nrestrictions_not_met_OnlyInRain: '&cCan be used only in rain.'\r\nrestrictions_not_met_OnlyAfterDamage: '&cCan only be used after beeing damaged.'\r\nrestrictions_not_met_OnlyAfterNotDamage: '&cCan only be used after not beeing damaged.'\r\nrestrictions_not_met_OnlyOnBlock: '&cCan only be used on specific blocks.'\r\nrestrictions_not_met_Offhand: '&cCan only be used on with another item in offhand.'\r\nrestrictions_not_met_Mainhand: '&cCan only be used on with another item in mainhand.'\r\nrestrictions_not_met_Skilled: '&cYou did not skill this trait.'\r\nrestrictions_not_met_Silence: '&cYou are currently silenced.'\r\nrestrictions_not_met_OnlyWhileSneaking: '&cCan only be used while sneaking.'\r\nrestrictions_not_met_OnlyWhileNotSneaking: '&cCan only be used while not sneaking.'\r\nrestrictions_not_met_NotOnBlock: '&cCan not be used on this block.'\r\nrestrictions_not_met_NeededPermission: '&cYou do not have the Permission.'\r\nrestrictions_not_met_Costs: '&cYou do not have the cost.'\r\nrestrictions_not_met_OutOfRange: '&cOut of range.'\r\nrestrictions_not_met_TargetFriendly: '&cTarget is friendly.'\r\nrestrictions_not_met_NoTarget: '&cNo target found.'\r\nsend_empty_message: '&cYou tried to send an empty Message.'\r\nsomething_disabled: '&c%VALUE% are disabled.'\r\nstun_ended: ' &cYou are not stunned any more.'\r\nstun_message: ' &cYou are stunned for &d %TIME% &cSeconds.'\r\nstun_still: ' &cYou are still stunned for &b%TIME% &cSeconds. You can not %ACTION%.'\r\nstun_success: '&aYou stunned &d%TARGET%&a.'\r\nsuccess: '&aSuccess.'\r\nsame_race_team: '&c%PLAYER% is in your Race Team.'\r\ntarget_not_exist: '&cTarget does not exist or is offline'\r\ntime_in_seconds: 'time in seconds'\r\ntoo_far_away: '&cTarget too far away.'\r\ntraits: 'traits'\r\ntrait_backstab_success: '&a%NAME% backstabed.'\r\ntrait_bash_success: '&a%NAME% stunned.'\r\ntrait_consume_success: '&aYou have been given &d%VALUE% &aMana. &d%MATERIAL% &aconsumed.'\r\ntrait_dodged: '&aYou dodged the Attack.'\r\ntrait_fly_toggle: '&aYou can now &dfly &afor &d%DURATION% &aseconds.'\r\ntrait_invisible_toggle: '&aYou are now &dinvisible &afor &d%DURATION% &aseconds.'\r\ntrait_kick_sucess: '&d%NAME% &akicked.'\r\ntrait_kick_failed: '&d%NAME% &akicked but did not abort anything.'\r\ntrait_laststand_success: '&d%NAME% &atoggled. You were healed &d%VALUE%&a.'\r\ntrait_lifetap_success: '&aYou have been given &d%VALUE% &aMana. You take &d%DAMAGE% &adamage.'\r\ntrait_heal_target_full: '&aTarget does not need any healing.'\r\ntrait_healed_target_success: '&d%TARGET% &ahealed.'\r\ntrait_healed_other_success: '&aHealed by &d%HEALER%&a.'\r\ntrait_mana_refill: '&a%VALUE% mana refilled.'\r\ntrait_pickup_success: '&aItem picked up.'\r\ntrait_pickup_inv_full: '&aInventory is full.'\r\ntrait_poison_success: '&a%TARGET% poisoned.'\r\ntrait_poison_imun: '&a%TARGET% is imun to poisoned.'\r\ntrait_poison_notify_other: '&cYou got Poisoned by %PLAYER%.'\r\ntrait_pushaway_success: '&d%TARGET% &apushed away.'\r\ntrait_horse_no_tame: '&cYou may not tame this Horse.'\r\ntrait_horse_no_leash: '&cYou may not leash this Horse.'\r\ntrait_horse_no_jump: '&cYou may not jump with this Horse.'\r\ntrait_silence_sucess: '&aYou silenced &d%NAME% &afor &d%DURATION% &aSeconds.'\r\ntrait_stun_arrow_success: '&aYou stunned &d%TARGET% &afor &d%DURATION% &aSeconds.'\r\ntrait_taunt_success: '&d%TARGET% &atauneted.'\r\ntrait_taunt_fade: '&aTaunt on &d%TARGET% &afaded.'\r\ntrait_teleport_solidtarger: '&cTarget is solid. Can not teleport.'\r\ntrait_teleport_success: '&aTeleported.'\r\ntrait_tool_trait_fail: '&cYou may not use this Tool.'\r\ntrait_wall_success: '&aWall created.'\r\ntrait_wall_faded: '&aWall disapears.'\r\ntrait_already_active: '&d%NAME% &c is already active.'\r\ntrait_cooldown: '&cYou still have &d%SECONDS% &cseconds cooldown on: &d%NAME%&c.'\r\ntrait_faded: '&d%NAME% &cfaded.'\r\ntrait_failed: '&d%NAME% &cfailed.'\r\ntrait_toggled: '&d%NAME% &atoggled.'\r\ntrait_kicked: '&d%NAME% &cgot kicked.'\r\nvalue_0_not_allowed: '&cValue of 0 is not allowed.'\r\nwand_select_message: '&a You have a &d WAND &ain your hand. Use &dLEFT &aClick to cast and &dRIGHT &aClick to switch spells. Current spell: &d%CURRENT_SPELL%&a.'\r\nwrong_command_use: '&cWrong usage. Use the command like this: &d%COMMAND%&c.'\r\nwhisper_yourself: '&cYou can not whisper yourself.'\r\nyour: 'your'\r\nyour_class: 'your Class'\r\nyour_race: 'your Race'\r\nyou_would_kill_yourself: '&cYou would kill yourself'\r\n"));
    private static boolean loggedError = false;

    protected List<YAMLConfigExtended> getYAMLOfFile(File file) {
        LinkedList<YAMLConfigExtended> returnList = new LinkedList<YAMLConfigExtended>();
        if (file == null || !file.exists()) {
            return returnList;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                returnList.addAll(this.getYAMLOfFile(subFile));
                ++n2;
            }
        }
        if (file.getName().endsWith(".yml")) {
            YAMLConfigExtended config = new YAMLConfigExtended(file).load();
            if (config.getValidLoad()) {
                returnList.add(config);
            } else {
                this.plugin.log("ERROR on loading Language File: " + file.getAbsolutePath());
            }
        }
        return returnList;
    }

    private static String readFromYAMLList(List<YAMLConfigExtended> configList, String tag) {
        for (YAMLConfigExtended config : configList) {
            if (!config.contains(tag)) continue;
            return config.getString(tag);
        }
        return null;
    }

    public DefaultTranslationManager(String language) {
        this.language = language;
    }

    @Override
    public Translator translate(String key, boolean tryInStdLanguageIfFails) throws TranslationNotFoundException {
        try {
            return this.tryPreferedTranslate(key);
        }
        catch (TranslationNotFoundException exp) {
            if (!loggedError) {
                RacesAndClasses.getPlugin().log("Translate failed! Check the debug.log . There can be more translation errors.");
                loggedError = true;
            }
            RacesAndClasses.getPlugin().getDebugLogger().logWarning("tried to translate: '" + exp.getTagNotFound() + "' in language: '" + exp.getLanguage() + "' but it was not found.");
            if (!tryInStdLanguageIfFails) {
                throw exp;
            }
            return this.trySTDTranslate(key);
        }
    }

    private Translator trySTDTranslate(String tag) throws TranslationNotFoundException {
        String translation = DefaultTranslationManager.readFromYAMLList(this.stdLanguageFiles, tag);
        if (translation == null) {
            throw new TranslationNotFoundException("en", tag);
        }
        return new Translator(translation);
    }

    private Translator tryPreferedTranslate(String tag) throws TranslationNotFoundException {
        String translation = DefaultTranslationManager.readFromYAMLList(this.languageConfiguration, tag);
        if (translation == null) {
            throw new TranslationNotFoundException(this.getCurrentLanguage(), tag);
        }
        return new Translator(translation);
    }

    @Override
    public TranslationManager init() {
        this.check_EN_isPresent();
        this.copy_all_known();
        String languagePath = this.plugin.getDataFolder() + File.separator + "language" + File.separator + this.language;
        File languageDir = new File(languagePath);
        if (!languageDir.exists()) {
            this.plugin.log("ERROR: Language with the name: " + this.language + " was not found. Loading English instead.");
            this.language = "en";
        }
        this.languageConfiguration = new LinkedList<YAMLConfigExtended>();
        this.languageConfiguration.addAll(this.getYAMLOfFile(languageDir));
        return this;
    }

    private void copy_all_known() {
        List<String> known = Arrays.asList("fr", "de");
        String baseDir = this.plugin.getDataFolder() + File.separator + "language" + File.separator;
        for (String lang : known) {
            if (new File(baseDir, lang).exists()) continue;
            try {
                InputStream in = this.plugin.getResource("trans/" + lang + ".yml");
                if (in == null) {
                    throw new IllegalArgumentException("Could not find Language file in JAR: 'trans/" + lang + ".yml'");
                }
                File base = new File(baseDir, lang);
                if (!base.exists()) {
                    base.mkdir();
                }
                Path out = new File(base, String.valueOf(lang) + ".yml").toPath();
                Files.copy(in, out, new CopyOption[0]);
                IOUtils.closeQuietly(in);
            }
            catch (Throwable exp) {
                this.plugin.logStackTrace("Could not copy Language file: " + lang, exp);
            }
        }
    }

    private void check_EN_isPresent() {
        File stdLanguageDir = new File(this.plugin.getDataFolder() + File.separator + "language" + File.separator + "en");
        if (!stdLanguageDir.exists()) {
            stdLanguageDir.mkdirs();
        }
        File enDefaultFile = new File(stdLanguageDir + File.separator + "en.yml");
        YAMLConfigExtended enConfig = new YAMLConfigExtended(enDefaultFile).load();
        YAMLConfigExtended defaultENConfig = new YAMLConfigExtended();
        try {
            defaultENConfig.loadFromString("already_are: '&cYou already are a &d%HOLDER%&c.'\r\nalread_full_mana: '&cYou already have full mana.'\r\nalready_have_class: '&cYou already have a class: &d%CLASS%&c. Use &c/class change&c to change your class.'\r\nalready_have_race: '&cYou already have a race: &d%RACE%&c. Use &c/race change&c to change your race.'\r\narmor: 'Armor'\r\narmor_not_allowed: '&cYou are not allowed to use &c%MATERIAL%&a.'\r\narrow_change: '&aSwitched arrows to: &d%TRAIT_NAME%&a.'\r\nbow_selected_message: '&a You have a &dBOW &ain your hand. Use &dLEFT &aClick to change through your arrows. Current arrow: &d%CURRENT_ARROW% &a.'\r\nbuff_activated: '&a You activated &d%BUFF%&a.'\r\nbuff_timeout: '&a Buff &d%BUFF% &atimedout.'\r\nbuff_used: '&a Buff &d%BUFF% &aused.'\r\nchannel_propertie: 'channelPropertie'\r\nchange_to_same_holder: '&cYou are already a &d%HOLDER%&c.'\r\nclass: 'class'\r\nclass_not_exist: '&cThe class &d%CLASS% &cdoes not exist.'\r\nclass_changed_to: '&cYour Class has been changed to: &d%CLASS%&c.'\r\nclass_changed_to_other: '&aClass of &d%PLAYER%&a changed to: &d%CLASS%&d.'\r\ncooldown_is_ready_again: '&d%TRAIT_NAME% &ais ready again.'\r\ncooldown_is_ready_in: '&cYou still have Cooldown. Ready in &d%TIME%&c.'\r\ndisabled_region: '&cYou may not use any Trait here.'\r\nfailed: '&cfailed'\r\nfood_cancle: '&aEating cancled.'\r\nfood_eat: '&cDo not move, or your eating will be cancled.'\r\nfood_finished: '&cEating finished.'\r\nhealed: '&aYou have been healed.'\r\nhealed_other: '&aYou have healed: &d%PLAYER%&a.'\r\nhealth: 'Health'\r\nhealth_full: 'Your health is full.'\r\nheld_item_not_air: '&aYou may not have an item in your hands.'\r\nholder_selectiongui_header: '&aSelect your &d%HOLDER%&a, %PLAYER%'\r\nholder_not_present: '&cYou have to be a %HOLDER% for this.'\r\nin_restricted_area: '&cYou may not use any Trait here.'\r\nlogin_no_race_selected: '&cYou have not selected a Race. Please select a race using /race select <racename>'\r\nlaunched_something: '&a%NAME% launched.'\r\nlevel_too_low: '&cYour level is too low.'\r\nlevel_up_message: '&aCongratulations, &d%PLAYER%&a. You leveled up to Level &d%LEVEL%&a.'\r\nlevel_up_new_skill_message: '&aYou have learned a new Skill: &d%TRAITNAME%&a.'\r\nmagic_chaneling_failed: '&cChaneling of &d%TRAIT_NAME% &cfailed.'\r\nmagic_change_spells: '&aChanged Spell to: &d%TRAIT_NAME% &aCost: &d%COST% %COST_TYPE%&a.'\r\nmagic_dont_have_enough: '&c You do not have enough &d%COST_TYPE% &cfor &d%TRAIT_NAME% &c.'\r\nmagic_no_spells: '&cYou can not cast any spells.'\r\nmagic_spell_activated: '&d%TRAIT_NAME% &aactivated.'\r\nmagic_spell_deactivated: '&d%TRAIT_NAME% &cdeactivated.'\r\nmana_already_full: '&cYour Mana is already full.'\r\nmana: 'mana'\r\nmember_config_not_found: '&cYour config could not be found. Try relogging or contact an Admin.'\r\nmember_config_changed: '&aThe Attribute &d%ATTRIBUTE%&a has been changed to: &d%VALUE%&a.'\r\nmember_config_attribute_not_found: '&cThe Attribute &d%ATTRIBUTE%&c could not be found.'\r\nneeds_1_arg: 'This command needs 1 argument: %COMMAND%'\r\nnew_value: 'new Value'\r\nno_class_in_list: 'No Classes in the list.'\r\nno_class_on_change: '@no_class_selected@. Use &d/class select &cto select a class.'\r\nno_class_selected_use_info: '&cYou have no class selected. Use &d/class info <class name> &cto inspect a class.'\r\nno_class_selected: '&cYou have no class selected.'\r\nno_class_to_select: '&c You do not have any Classes to select.'\r\nno_find_trait: '&c Could not find this trait.'\r\nno_healthcontainer_found: '&cSomething gone Wrong. No healthcontainer found for you.'\r\nno_message: '&cNo message given.'\r\nnumber_not_readable: '&cNumber could not be read.'\r\nno_race_selected: '&cYou have no race selected.'\r\nno_race_to_select: '&c You do not have any Race to select.'\r\nno_taget_found: '&cNo target found.'\r\nno_traits: '&cNo Traits.'\r\nonly_players: '&cThis command can only be used by Players.'\r\nopen_holder: '&2Opening %HOLDER% Selection....'\r\nopen_traits: '&a Opening Traits of &d%PLAYER%&a.'\r\npassword: 'password'\r\npermission_not_present: '&cYou do not have the Permission to do that.'\r\nplayer_not_exist: '&cPlayer &d%PLAYER%&c does not exist.'\r\nplugin_pre: '&4[RaC]'\r\nquick_slot_item_lore: '&4Throw this item away in the Inventory to remove it.'\r\nquick_slot_selected: '&4Quickslot item recieved in inventory.'\r\nrace: 'race'\r\nrace_not_exist: '&cThe race &d%RACE% &cdoes not exist.'\r\nrace_changed_to: '&cYour Race has been changed to: &d%RACE%&c.'\r\nrace_changed_to_other: '&aRace of &d%PLAYER%&a changed to: &d%RACE%&d.'\r\nrace_spawn_created: '&aRace-Spawn of &d%RACE% &acreated.'\r\nrace_spawn_no_spawnpoint: '&cThe race &d%RACE% &chas no spawnpoint.'\r\nrace_spawn_teleport_success: '&aWelcome to the Race Spawn of &d%RACE%&a.'\r\nreload_message: '&aReload of &dRaces &adone successfully. Time taken: &d %TIME% &ams'\r\nrestrictions_not_met: '&aThe Trait still has cooldown or may not be used here..'\r\nrestrictions_not_met_MinimumLevel: '&cYour level is too low.'\r\nrestrictions_not_met_MaximumLevel: '&cYour level is too hight.'\r\nrestrictions_not_Biomes: '&cCan not be used in this biome'\r\nrestrictions_not_met_Wearing: '&cYou are not wearing the correct clothings.'\r\nrestrictions_not_met_OnlyInWater: '&cCan be used only in water.'\r\nrestrictions_not_met_OnlyInWorld: '&cCan be used only on another world.'\r\nrestrictions_not_met_OnlyOnLand: '&cCan be used only on land.'\r\nrestrictions_not_met_OnlyInLava: '&cCan be used only in lava.'\r\nrestrictions_not_met_OnlyOnSnow: '&cCan be used only on snow.'\r\nrestrictions_not_met_OnlyInNight: '&cCan be used only in night.'\r\nrestrictions_not_met_OnlyOnDay: '&cCan be used only on day.'\r\nrestrictions_not_met_Cooldown: '&cStill has cooldown.'\r\nrestrictions_not_met_AboveLevitation: '&cYour elevation is too low.'\r\nrestrictions_not_met_BelowLevitation: '&cYour elevation is too high.'\r\nrestrictions_not_met_OnlyInRain: '&cCan be used only in rain.'\r\nrestrictions_not_met_OnlyAfterDamage: '&cCan only be used after beeing damaged.'\r\nrestrictions_not_met_OnlyAfterNotDamage: '&cCan only be used after not beeing damaged.'\r\nrestrictions_not_met_OnlyOnBlock: '&cCan only be used on specific blocks.'\r\nrestrictions_not_met_Offhand: '&cCan only be used on with another item in offhand.'\r\nrestrictions_not_met_Mainhand: '&cCan only be used on with another item in mainhand.'\r\nrestrictions_not_met_Skilled: '&cYou did not skill this trait.'\r\nrestrictions_not_met_Silence: '&cYou are currently silenced.'\r\nrestrictions_not_met_OnlyWhileSneaking: '&cCan only be used while sneaking.'\r\nrestrictions_not_met_OnlyWhileNotSneaking: '&cCan only be used while not sneaking.'\r\nrestrictions_not_met_NotOnBlock: '&cCan not be used on this block.'\r\nrestrictions_not_met_NeededPermission: '&cYou do not have the Permission.'\r\nrestrictions_not_met_Costs: '&cYou do not have the cost.'\r\nrestrictions_not_met_OutOfRange: '&cOut of range.'\r\nrestrictions_not_met_TargetFriendly: '&cTarget is friendly.'\r\nrestrictions_not_met_NoTarget: '&cNo target found.'\r\nsend_empty_message: '&cYou tried to send an empty Message.'\r\nsomething_disabled: '&c%VALUE% are disabled.'\r\nstun_ended: ' &cYou are not stunned any more.'\r\nstun_message: ' &cYou are stunned for &d %TIME% &cSeconds.'\r\nstun_still: ' &cYou are still stunned for &b%TIME% &cSeconds. You can not %ACTION%.'\r\nstun_success: '&aYou stunned &d%TARGET%&a.'\r\nsuccess: '&aSuccess.'\r\nsame_race_team: '&c%PLAYER% is in your Race Team.'\r\ntarget_not_exist: '&cTarget does not exist or is offline'\r\ntime_in_seconds: 'time in seconds'\r\ntoo_far_away: '&cTarget too far away.'\r\ntraits: 'traits'\r\ntrait_backstab_success: '&a%NAME% backstabed.'\r\ntrait_bash_success: '&a%NAME% stunned.'\r\ntrait_consume_success: '&aYou have been given &d%VALUE% &aMana. &d%MATERIAL% &aconsumed.'\r\ntrait_dodged: '&aYou dodged the Attack.'\r\ntrait_fly_toggle: '&aYou can now &dfly &afor &d%DURATION% &aseconds.'\r\ntrait_invisible_toggle: '&aYou are now &dinvisible &afor &d%DURATION% &aseconds.'\r\ntrait_kick_sucess: '&d%NAME% &akicked.'\r\ntrait_kick_failed: '&d%NAME% &akicked but did not abort anything.'\r\ntrait_laststand_success: '&d%NAME% &atoggled. You were healed &d%VALUE%&a.'\r\ntrait_lifetap_success: '&aYou have been given &d%VALUE% &aMana. You take &d%DAMAGE% &adamage.'\r\ntrait_heal_target_full: '&aTarget does not need any healing.'\r\ntrait_healed_target_success: '&d%TARGET% &ahealed.'\r\ntrait_healed_other_success: '&aHealed by &d%HEALER%&a.'\r\ntrait_mana_refill: '&a%VALUE% mana refilled.'\r\ntrait_pickup_success: '&aItem picked up.'\r\ntrait_pickup_inv_full: '&aInventory is full.'\r\ntrait_poison_success: '&a%TARGET% poisoned.'\r\ntrait_poison_imun: '&a%TARGET% is imun to poisoned.'\r\ntrait_poison_notify_other: '&cYou got Poisoned by %PLAYER%.'\r\ntrait_pushaway_success: '&d%TARGET% &apushed away.'\r\ntrait_horse_no_tame: '&cYou may not tame this Horse.'\r\ntrait_horse_no_leash: '&cYou may not leash this Horse.'\r\ntrait_horse_no_jump: '&cYou may not jump with this Horse.'\r\ntrait_silence_sucess: '&aYou silenced &d%NAME% &afor &d%DURATION% &aSeconds.'\r\ntrait_stun_arrow_success: '&aYou stunned &d%TARGET% &afor &d%DURATION% &aSeconds.'\r\ntrait_taunt_success: '&d%TARGET% &atauneted.'\r\ntrait_taunt_fade: '&aTaunt on &d%TARGET% &afaded.'\r\ntrait_teleport_solidtarger: '&cTarget is solid. Can not teleport.'\r\ntrait_teleport_success: '&aTeleported.'\r\ntrait_tool_trait_fail: '&cYou may not use this Tool.'\r\ntrait_wall_success: '&aWall created.'\r\ntrait_wall_faded: '&aWall disapears.'\r\ntrait_already_active: '&d%NAME% &c is already active.'\r\ntrait_cooldown: '&cYou still have &d%SECONDS% &cseconds cooldown on: &d%NAME%&c.'\r\ntrait_faded: '&d%NAME% &cfaded.'\r\ntrait_failed: '&d%NAME% &cfailed.'\r\ntrait_toggled: '&d%NAME% &atoggled.'\r\ntrait_kicked: '&d%NAME% &cgot kicked.'\r\nvalue_0_not_allowed: '&cValue of 0 is not allowed.'\r\nwand_select_message: '&a You have a &d WAND &ain your hand. Use &dLEFT &aClick to cast and &dRIGHT &aClick to switch spells. Current spell: &d%CURRENT_SPELL%&a.'\r\nwrong_command_use: '&cWrong usage. Use the command like this: &d%COMMAND%&c.'\r\nwhisper_yourself: '&cYou can not whisper yourself.'\r\nyour: 'your'\r\nyour_class: 'your Class'\r\nyour_race: 'your Race'\r\nyou_would_kill_yourself: '&cYou would kill yourself'\r\n");
        }
        catch (InvalidConfigurationException exp) {
            this.plugin.getDebugLogger().logStackTrace(exp);
            return;
        }
        boolean hasToSave = false;
        for (String key : defaultENConfig.getRootChildren()) {
            if (enConfig.isString(key) && !enConfig.getString(key).contains("TRATINAME")) continue;
            enConfig.set(key, defaultENConfig.get(key));
            hasToSave = true;
        }
        if (hasToSave) {
            enConfig.save();
        }
    }

    @Override
    public void reload() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getCurrentLanguage() {
        return this.language;
    }
}

