/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.statictraits;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.configuration.traits.TraitConfig;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class STDAxeDamageTrait
extends AbstractBasicTrait {
    private RacesAndClasses plugin = RacesAndClasses.getPlugin();
    private double woodDmg;
    private double stoneDmg;
    private double goldDmg;
    private double ironDmg;
    private double diamondDmg;

    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class})
    public void generalInit() {
        TraitConfig config = this.plugin.getConfigManager().getTraitConfigManager().getConfigOfTrait(this.getName());
        if (config != null) {
            this.woodDmg = ((Integer)config.getValue("trait.damage.wood", 4.0)).intValue();
            this.stoneDmg = ((Integer)config.getValue("trait.damage.stone", 5.0)).intValue();
            this.goldDmg = ((Integer)config.getValue("trait.damage.gold", 4.0)).intValue();
            this.ironDmg = ((Integer)config.getValue("trait.damage.iron", 6.0)).intValue();
            this.diamondDmg = ((Integer)config.getValue("trait.damage.diamond", 7.0)).intValue();
        }
    }

    @Override
    public String getName() {
        return "STDAxeDamageTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "";
    }

    @Override
    @TraitConfigurationNeeded
    public void setConfiguration(TraitConfiguration configMap) {
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Player player;
        double newDmg;
        Event event = eventWrapper.getEvent();
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return TraitResults.False();
        }
        EntityDamageByEntityEvent Eevent = (EntityDamageByEntityEvent)event;
        if (Eevent.getDamager() instanceof Player && (newDmg = this.getDamageOfAxe((player = (Player)Eevent.getDamager()).getInventory().getItem(player.getInventory().getHeldItemSlot()).getType())) != -1.0) {
            CompatibilityModifier.EntityDamage.safeSetDamage(newDmg, (EntityDamageEvent)Eevent);
            return TraitResults.True();
        }
        return TraitResults.False();
    }

    private double getDamageOfAxe(Material material) {
        if (material == null) {
            return -1.0;
        }
        switch (material) {
            case WOOD_AXE: {
                return this.woodDmg;
            }
            case STONE_AXE: {
                return this.stoneDmg;
            }
            case GOLD_AXE: {
                return this.goldDmg;
            }
            case IRON_AXE: {
                return this.ironDmg;
            }
            case DIAMOND_AXE: {
                return this.diamondDmg;
            }
        }
        return -1.0;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return true;
    }

    @Override
    @TraitInfos(category="static", traitName="STDAxeDamageTrait", visible=false)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        return true;
    }

    @Override
    public boolean isStackable() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

