/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.statictraits;

import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.configuration.traits.TraitConfig;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.StaticTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.util.consts.Consts;
import de.tobiyas.racesandclasses.util.items.CreateDropContainer;
import de.tobiyas.racesandclasses.util.items.DropContainer;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.LazyMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class DeathCheckerTrait
extends AbstractBasicTrait
implements StaticTrait {
    private HashMap<EntityType, DropContainer> dropMap;
    private RacesAndClasses plugin;
    private static final String SPAWNER_KEY = "spawner_spawned";

    @Override
    @TraitEventsUsed(registerdClasses={EntityDeathEvent.class, CreatureSpawnEvent.class})
    public void generalInit() {
        this.plugin = RacesAndClasses.getPlugin();
        this.dropMap = new HashMap();
        TraitConfig config = this.plugin.getConfigManager().getTraitConfigManager().getConfigOfTrait(this.getName());
        if (config == null) {
            this.initListsDefault();
        }
        this.readListFromConfig(config);
    }

    private void readListFromConfig(TraitConfig config) {
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType type = entityTypeArray[n2];
            String path = String.valueOf(Consts.traitConfigDir) + "DropRates.yml";
            DropContainer container = CreateDropContainer.loadDropContainer(path, type);
            if (container != null) {
                this.dropMap.put(type, container);
            }
            ++n2;
        }
    }

    private void initListsDefault() {
        String path = String.valueOf(Consts.traitConfigDir) + "DropRates.yml";
        CreateDropContainer.createAllContainers(path);
    }

    @Override
    public String getName() {
        return "DropRates";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "";
    }

    @Override
    @TraitConfigurationNeeded
    public void setConfiguration(TraitConfiguration configMap) {
    }

    @Override
    public TraitRestriction checkRestrictions(EventWrapper wrapper) {
        return TraitRestriction.None;
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        if (event instanceof CreatureSpawnEvent) {
            if (((CreatureSpawnEvent)event).getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
                ((CreatureSpawnEvent)event).getEntity().setMetadata(SPAWNER_KEY, (MetadataValue)new LazyMetadataValue((Plugin)this.plugin, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return true;
                    }
                }));
                return TraitResults.True();
            }
            return TraitResults.False();
        }
        if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_enable_expDropBonus()) {
            return TraitResults.False();
        }
        if (!(event instanceof EntityDeathEvent)) {
            return TraitResults.False();
        }
        EntityDeathEvent Eevent = (EntityDeathEvent)event;
        LivingEntity entity = Eevent.getEntity();
        if (entity == null || entity instanceof Player) {
            return TraitResults.False();
        }
        int exp = Eevent.getDroppedExp();
        List items = Eevent.getDrops();
        Eevent.setDroppedExp(this.modifyEXP(exp, entity));
        this.modifyItems(items, entity);
        if (Eevent.getEntity().getMetadata(SPAWNER_KEY).isEmpty()) {
            return TraitResults.False();
        }
        Player killerTemp = entity.getKiller();
        RaCPlayer killer = RaCPlayerManager.get().getPlayer(killerTemp);
        if (killer != null) {
            int expForLevel = (int)((double)Eevent.getDroppedExp() / 10.0);
            killer.getLevelManager().addExp(expForLevel);
        }
        return TraitResults.True();
    }

    private int modifyEXP(int exp, LivingEntity entity) {
        DropContainer container = this.dropMap.get(entity.getType());
        if (container == null) {
            return exp;
        }
        return container.getEXP();
    }

    private void modifyItems(List<ItemStack> list, LivingEntity entity) {
        DropContainer container = this.dropMap.get(entity.getType());
        if (container == null) {
            return;
        }
        for (ItemStack stack : container.getItems()) {
            list.add(stack);
        }
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return true;
    }

    @Override
    @TraitInfos(category="static", traitName="DropTrait", visible=false)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        return true;
    }

    @Override
    public boolean isStackable() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

