/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.statictraits;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.events.inventoryitemevents.PlayerEquipsArmorEvent;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.bypasses.StaticTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitInfos;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ArmorTrait
extends AbstractBasicTrait
implements StaticTrait {
    protected RacesAndClasses plugin = RacesAndClasses.getPlugin();

    @Override
    @TraitEventsUsed(registerdClasses={PlayerEquipsArmorEvent.class})
    public void generalInit() {
    }

    @Override
    public String getName() {
        return "ArmorTrait";
    }

    @Override
    protected String getPrettyConfigIntern() {
        return "";
    }

    @Override
    @TraitConfigurationNeeded
    public void setConfiguration(TraitConfiguration configMap) {
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        if (!(event instanceof PlayerEquipsArmorEvent)) {
            return TraitResults.False();
        }
        PlayerEquipsArmorEvent playerEquipEvent = (PlayerEquipsArmorEvent)event;
        RaCPlayer player = eventWrapper.getPlayer();
        if (player == null) {
            return TraitResults.False();
        }
        ItemStack armorItem = playerEquipEvent.getArmorItem();
        if (armorItem == null) {
            return TraitResults.False();
        }
        if (!player.getArmorManager().hasPermissionForItem(armorItem)) {
            String matName = this.getMaterialName(armorItem.getType());
            LanguageAPI.sendTranslatedMessage(player, "armor_not_allowed", "material", matName);
            playerEquipEvent.setCancelled(true);
        }
        return TraitResults.True();
    }

    private String getMaterialName(Material material) {
        StringBuilder materialName = new StringBuilder();
        String[] stringArray = material.toString().toLowerCase().split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            materialName.append(Character.toUpperCase(c.charAt(0))).append(c, 1, c.length()).append(" ");
            ++n2;
        }
        return materialName.toString().trim();
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return true;
    }

    @Override
    @TraitInfos(category="static", traitName="AromrTrait", visible=false)
    public void importTrait() {
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        return true;
    }

    @Override
    public boolean isStackable() {
        return false;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

