/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.resistance;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.TraitHolderCombinder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.ResistanceInterface;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.util.traitutil.TraitStringUtils;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public abstract class AbstractResistance
extends AbstractBasicTrait
implements ResistanceInterface {
    protected List<EntityDamageEvent.DamageCause> resistances;
    protected double value;
    protected String operation = "";

    @Override
    public abstract String getName();

    @Override
    protected String getPrettyConfigIntern() {
        return String.valueOf(this.operation) + " " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="operation", classToExpect=String.class), @TraitConfigurationField(fieldName="value", classToExpect=Double.class)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.operation = configMap.getAsString("operation");
        this.value = configMap.getAsDouble("value");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        TraitResults result = new TraitResults();
        if (!(event instanceof EntityDamageEvent)) {
            return result.setTriggered(false);
        }
        EntityDamageEvent Eevent = (EntityDamageEvent)event;
        Entity entity = Eevent.getEntity();
        if (!(entity instanceof Player)) {
            return result.setTriggered(false);
        }
        if (TraitHolderCombinder.checkContainer(eventWrapper.getPlayer(), this) && this.getResistanceTypes().contains(Eevent.getCause())) {
            if (this.instantCancle()) {
                CompatibilityModifier.EntityDamage.safeSetDamage(0.0, Eevent);
                Eevent.setCancelled(true);
                return result;
            }
            double oldDmg = CompatibilityModifier.EntityDamage.safeGetDamage(Eevent);
            double modified = this.modifyToPlayer(eventWrapper.getPlayer(), this.value, "absorb");
            double newDmg = TraitStringUtils.getNewValue(oldDmg, this.operation, modified);
            CompatibilityModifier.EntityDamage.safeSetDamage(newDmg, Eevent);
            return result;
        }
        return result.setTriggered(false);
    }

    private boolean instantCancle() {
        return this.operation.equals("*") && this.value == 0.0;
    }

    @Override
    public List<EntityDamageEvent.DamageCause> getResistanceTypes() {
        return this.resistances;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (trait.getClass() != this.getClass()) {
            return false;
        }
        AbstractResistance otherTrait = (AbstractResistance)trait;
        return this.value >= otherTrait.value;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        PlayerAction action = wrapper.getPlayerAction();
        if (action != PlayerAction.TAKE_DAMAGE) {
            return false;
        }
        EntityDamageEvent.DamageCause cause = wrapper.getDamageCause();
        return this.getResistanceTypes().contains(cause);
    }
}

