/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.pattern;

import de.tobiyas.racesandclasses.datacontainer.traitholdercontainer.AbstractTraitHolder;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapperFactory;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class TickEverySecondsTrait
extends AbstractBasicTrait {
    private BukkitTask schedulerTask;
    protected int seconds = 1;

    @Override
    @TraitEventsUsed(registerdClasses={})
    public void generalInit() {
        this.schedulerTask = new DebugBukkitRunnable(this.getName()){

            @Override
            public void runIntern() {
                TickEverySecondsTrait.this.tickEverySecondsMethod();
            }
        }.runTaskTimer((Plugin)plugin, this.seconds * 20, this.seconds * 20);
    }

    private final void tickEverySecondsMethod() {
        this.tickEverySecondsAditionalBefore();
        for (AbstractTraitHolder holder : this.holders) {
            for (RaCPlayer player : holder.getHolderManager().getAllPlayersOfHolder(holder)) {
                if (player == null || !player.isOnline() || !this.permanentSkill && plugin.getConfigManager().getGeneralConfig().isConfig_useSkillSystem() && player.getSkillTreeManager().getLevel(this) <= 0) continue;
                EventWrapper fakeEventWrapper = EventWrapperFactory.buildOnlyWithplayer(player.getPlayer());
                if (this.checkRestrictions(fakeEventWrapper) != TraitRestriction.None || !this.canBeTriggered(fakeEventWrapper)) {
                    this.restrictionsFailed(player);
                    continue;
                }
                if (!this.tickDoneForPlayer(player)) continue;
                plugin.getStatistics().traitTriggered(this);
            }
        }
        this.tickEverySecondsAditionalAfter();
    }

    protected void tickEverySecondsAditionalBefore() {
    }

    protected void tickEverySecondsAditionalAfter() {
    }

    protected void restrictionsFailed(RaCPlayer player) {
    }

    protected abstract boolean tickDoneForPlayer(RaCPlayer var1);

    @Override
    public void deInit() {
        super.deInit();
        if (this.schedulerTask != null) {
            this.schedulerTask.cancel();
        }
    }

    @Override
    protected String getPrettyConfigIntern() {
        String reason = "Nothing";
        if (this.onlyInLava) {
            reason = "in Lava";
        }
        if (this.onlyInWater) {
            reason = "in Water";
        }
        if (this.onlyOnLand) {
            reason = "on Land";
        }
        if (this.onlyOnDay && !this.onlyInNight) {
            reason = "on DayLight";
        }
        if (this.onlyInNight && !this.onlyOnDay) {
            reason = "in NightShine";
        }
        return String.valueOf(this.getPrettyConfigurationPre()) + " every: " + this.seconds + " sec for " + reason;
    }

    protected abstract String getPrettyConfigurationPre();

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="seconds", classToExpect=Integer.class, optional=false)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.seconds = configMap.getAsInt("seconds");
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        return new TraitResults();
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof TickEverySecondsTrait)) {
            return false;
        }
        TickEverySecondsTrait otherTrait = (TickEverySecondsTrait)trait;
        return this.seconds >= otherTrait.seconds;
    }

    @Override
    public boolean isStackable() {
        return true;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        RaCPlayer player = wrapper.getPlayer();
        int level = player.getLocation().getBlockY();
        if (level < 0 || level >= 256) {
            return false;
        }
        byte lightFromSky = player.getLocation().getBlock().getLightFromSky();
        return !this.onlyOnDay || lightFromSky <= 2;
    }
}

