/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.pattern;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.passive.AbstractPassiveTrait;
import de.tobiyas.racesandclasses.util.bukkit.versioning.compatibility.CompatibilityModifier;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractWeaponDamageIncreaseTrait
extends AbstractPassiveTrait {
    protected final Set<Material> weapons = new HashSet<Material>();

    @Override
    @TraitEventsUsed(registerdClasses={EntityDamageByEntityEvent.class})
    public void generalInit() {
    }

    @Override
    protected String getPrettyConfigIntern() {
        return String.valueOf(this.operation) + " " + this.value;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="operation", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="value", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.operation = configMap.getAsString("operation", "+");
        this.value = configMap.getAsDouble("value", 0.0);
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        EntityDamageByEntityEvent Eevent = (EntityDamageByEntityEvent)event;
        double newValue = this.getNewValue(eventWrapper.getPlayer(), Eevent.getDamage(), "damage");
        CompatibilityModifier.EntityDamage.safeSetDamage(newValue, (EntityDamageEvent)Eevent);
        return TraitResults.True();
    }

    private boolean checkItemIsWeapon(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Material itemMat = stack.getType();
        for (Material mat : this.weapons) {
            if (mat != itemMat) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        if (!(trait instanceof AbstractWeaponDamageIncreaseTrait)) {
            return false;
        }
        AbstractWeaponDamageIncreaseTrait otherTrait = (AbstractWeaponDamageIncreaseTrait)trait;
        return this.value >= otherTrait.value;
    }

    public static List<String> getHelpForTrait() {
        LinkedList<String> helpList = new LinkedList<String>();
        helpList.add(ChatColor.YELLOW + "The trait increases the Damage of your Weapon.");
        return helpList;
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (wrapper.getPlayerAction() != PlayerAction.DO_DAMAGE) {
            return false;
        }
        Player player = wrapper.getPlayer().getPlayer();
        return this.checkItemIsWeapon(player.getInventory().getItem(player.getInventory().getHeldItemSlot()));
    }
}

