/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.pattern;

import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.friend.TargetType;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public abstract class AbstractTotemTrait
extends AbstractMagicSpellTrait {
    protected int duration = 5;
    protected int range = 10;
    protected TargetType target = TargetType.ALL;
    protected int tickEvery = 1;
    protected Material topMaterial = Material.SKULL;
    protected Material bottomMaterial = Material.FENCE;
    protected final Map<RaCPlayer, TotemInfos> activedTotems = new HashMap<RaCPlayer, TotemInfos>();
    private final Random rand = new Random();

    @Override
    @TraitEventsUsed(bypassClasses={BlockBreakEvent.class})
    public void generalInit() {
    }

    @Override
    protected TraitResults otherEventTriggered(EventWrapper eventWrapper, TraitResults result) {
        result = TraitResults.False();
        if (eventWrapper.getEvent() instanceof BlockBreakEvent) {
            BlockBreakEvent bEvent = (BlockBreakEvent)eventWrapper.getEvent();
            Block block = bEvent.getBlock();
            for (TotemInfos totem : this.activedTotems.values()) {
                if (block.equals(totem.topLocation.getBlock())) {
                    this.removePlacedTotem(totem);
                    bEvent.setCancelled(true);
                    return result;
                }
                if (!block.equals(totem.bottomLocation.getBlock())) continue;
                this.removePlacedTotem(totem);
                bEvent.setCancelled(true);
                return result;
            }
        }
        return result;
    }

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        Location location = this.getLocationNear(player);
        if (location == null) {
            result.setTriggered(false);
            return;
        }
        result.copyFrom(this.placeTotem(player, location));
    }

    private Location getLocationNear(RaCPlayer player) {
        Location base = player.getLocation().clone();
        LinkedList<Location> free = new LinkedList<Location>();
        int x = -2;
        while (x <= 2) {
            int z = -2;
            while (z <= 2) {
                Location toCheck = base.clone().add((double)x, 0.0, (double)z);
                if (this.isFree(toCheck.clone())) {
                    free.add(toCheck);
                }
                ++z;
            }
            ++x;
        }
        return free.isEmpty() ? null : (Location)free.get(this.rand.nextInt(free.size()));
    }

    private boolean isFree(Location location) {
        if (location.getBlock().getType() != Material.AIR) {
            return false;
        }
        return location.add(0.0, 1.0, 0.0).getBlock().getType() == Material.AIR;
    }

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="duration", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="bottomBlock", classToExpect=Material.class, optional=true), @TraitConfigurationField(fieldName="upperBlock", classToExpect=Material.class, optional=true), @TraitConfigurationField(fieldName="range", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="tickEvery", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="target", classToExpect=String.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey("duration")) {
            this.duration = (Integer)configMap.get("duration");
        }
        if (configMap.containsKey("bottomBlock")) {
            this.bottomMaterial = (Material)configMap.get("bootomBlock");
        }
        if (configMap.containsKey("upperBlock")) {
            this.topMaterial = (Material)configMap.get("upperBlock");
        }
        if (configMap.containsKey("tickEvery")) {
            this.tickEvery = (Integer)configMap.get("tickEvery");
        }
        if (configMap.containsKey("range")) {
            this.range = (Integer)configMap.get("range");
        }
        if (configMap.containsKey("target")) {
            String target = configMap.getAsString("target").toLowerCase();
            if (target.startsWith("all")) {
                this.target = TargetType.ALL;
            }
            if (target.startsWith("fr") || target.startsWith("ally")) {
                this.target = TargetType.FRIEND;
            }
            if (target.startsWith("e") || target.startsWith("fe")) {
                this.target = TargetType.ENEMY;
            }
        }
    }

    protected TraitResults placeTotem(RaCPlayer player, Location location) {
        Location bottomLocation = location.clone();
        Location topLocation = location.clone().add(0.0, 1.0, 0.0);
        TotemInfos infos = new TotemInfos();
        infos.bottomLocation = bottomLocation.clone();
        infos.topLocation = topLocation.clone();
        infos.owner = player;
        bottomLocation.getBlock().setType(this.bottomMaterial);
        topLocation.getBlock().setType(this.topMaterial);
        this.activedTotems.put(player, infos);
        this.scheduleRemove(infos);
        return TraitResults.True();
    }

    protected void scheduleRemove(final TotemInfos infos) {
        int bukkitSchedulerID;
        infos.bukkitSchedulerID = bukkitSchedulerID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                AbstractTotemTrait.this.totemTick(infos);
            }
        }, 0L, (long)(this.tickEvery * 20));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                AbstractTotemTrait.this.removePlacedTotem(infos);
            }
        }, (long)(20 * this.duration));
    }

    protected void totemTick(TotemInfos infos) {
        Location loc = infos.topLocation;
        LinkedList<Player> near = new LinkedList<Player>();
        int squaredRange = this.range * this.range;
        for (Player player : loc.getWorld().getPlayers()) {
            if (!(player.getLocation().distanceSquared(loc) <= (double)squaredRange)) continue;
            near.add(player);
        }
        for (Player player : near) {
            if (this.target == TargetType.ENEMY && !EnemyChecker.areEnemies((Entity)infos.getOwner().getPlayer(), (Entity)player) || this.target == TargetType.FRIEND && !EnemyChecker.areAllies((Entity)infos.getOwner().getPlayer(), (Entity)player)) continue;
            this.tickOnPlayer(infos, player);
        }
        LinkedList<LivingEntity> entities = new LinkedList<LivingEntity>();
        for (Entity entity : loc.getWorld().getEntities()) {
            if (!(entity instanceof LivingEntity) || !(entity.getLocation().distanceSquared(loc) <= (double)squaredRange)) continue;
            entities.add((LivingEntity)entity);
        }
        for (LivingEntity livingEntity : entities) {
            if (this.target == TargetType.ENEMY && !EnemyChecker.areEnemies((Entity)infos.getOwner().getPlayer(), (Entity)livingEntity) || this.target == TargetType.FRIEND && !EnemyChecker.areAllies((Entity)infos.getOwner().getPlayer(), (Entity)livingEntity)) continue;
            this.tickOnNonPlayer(infos, livingEntity);
        }
    }

    protected abstract void tickOnPlayer(TotemInfos var1, Player var2);

    protected abstract void tickOnNonPlayer(TotemInfos var1, LivingEntity var2);

    protected void removePlacedTotem(TotemInfos infos) {
        Location bottomLocation = infos.bottomLocation;
        Location topLocation = infos.topLocation;
        if (bottomLocation == null || topLocation == null) {
            return;
        }
        bottomLocation.getBlock().setType(Material.AIR);
        topLocation.getBlock().setType(Material.AIR);
        this.activedTotems.remove(infos.owner);
        Bukkit.getScheduler().cancelTask(infos.bukkitSchedulerID);
    }

    protected boolean isTotem(Location location) {
        Block block = location.getBlock();
        for (TotemInfos info : this.activedTotems.values()) {
            Location top = info.topLocation;
            Location bottom = info.bottomLocation;
            if (top.getBlock() != block && bottom.getBlock() != block) continue;
            return true;
        }
        return false;
    }

    protected static class TotemInfos {
        protected Location bottomLocation;
        protected Location topLocation;
        protected int bukkitSchedulerID;
        protected RaCPlayer owner;

        protected TotemInfos() {
        }

        public Location getBottomLocation() {
            return this.bottomLocation.clone();
        }

        public Location getTopLocation() {
            return this.topLocation.clone();
        }

        public int getBukkitSchedulerID() {
            return this.bukkitSchedulerID;
        }

        public RaCPlayer getOwner() {
            return this.owner;
        }
    }
}

