/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.pattern;

import de.tobiyas.racesandclasses.APIs.BuffAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.ParticleContainer;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import de.tobiyas.util.RaC.schedule.DebugBukkitRunnable;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class AbstractBuffTrait
extends AbstractMagicSpellTrait {
    protected int duration = 5;
    protected final Map<RaCPlayer, BukkitTask> taskMap = new HashMap<RaCPlayer, BukkitTask>();
    protected boolean stayActiveTillTimeout = false;
    protected ParticleContainer particlesWhileActive = null;
    protected ParticleContainer particlesWhenUsed = null;

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="duration", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="stayActiveTillTimeout", classToExpect=Boolean.class, optional=true), @TraitConfigurationField(fieldName="particlesWhileActive", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="particlesWhenUsed", classToExpect=String.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.duration = configMap.getAsInt("duration", 5);
        this.stayActiveTillTimeout = configMap.getAsBool("stayActiveTillTimeout", false);
        this.particlesWhileActive = configMap.getAsParticleContainer("particlesWhileActive", null);
        this.particlesWhenUsed = configMap.getAsParticleContainer("particlesWhenUsed", null);
    }

    @Override
    public final void magicSpellTriggered(final RaCPlayer player, TraitResults result) {
        if (this.taskMap.containsKey(player)) {
            result.copyFrom(TraitResults.False());
            return;
        }
        player.sendTranslatedMessage("buff_activated", "buff", this.getDisplayName());
        this.buffActivated(player);
        BukkitTask task = new DebugBukkitRunnable("BuffTrait" + this.getDisplayName()){
            int i;
            {
                super($anonymous0);
                this.i = 1;
            }

            @Override
            protected void runIntern() {
                boolean stillActive = AbstractBuffTrait.this.taskMap.containsKey(player);
                if (AbstractBuffTrait.this.particlesWhileActive != null && stillActive) {
                    Vollotile.get().sendOwnParticleEffectToAll(AbstractBuffTrait.this.particlesWhileActive, player.getLocation());
                }
                if (this.i >= AbstractBuffTrait.this.duration) {
                    this.cancel();
                    if (stillActive) {
                        AbstractBuffTrait.this.taskMap.remove(player);
                        AbstractBuffTrait.this.buffTimeouted(player);
                        BuffAPI.removeBuff(player.getUniqueId(), AbstractBuffTrait.this.getDisplayName());
                        player.sendTranslatedMessage("buff_timeout", "buff", AbstractBuffTrait.this.getDisplayName());
                    }
                }
                ++this.i;
            }
        }.runTaskTimer((Plugin)RacesAndClasses.getPlugin(), 1L, 20L);
        this.taskMap.put(player, task);
        BuffAPI.addBuff(player.getUniqueId(), this.getDisplayName(), System.currentTimeMillis() + (long)(this.duration * 1000));
        result.copyFrom(TraitResults.True());
    }

    protected abstract void buffActivated(RaCPlayer var1);

    protected boolean isActive(RaCPlayer player) {
        return this.taskMap.containsKey(player);
    }

    protected void buffUsed(RaCPlayer player) {
        if (this.particlesWhenUsed != null) {
            Vollotile.get().sendOwnParticleEffectToAll(this.particlesWhenUsed, player.getLocation());
        }
        if (this.stayActiveTillTimeout) {
            return;
        }
        player.sendTranslatedMessage("buff_used", "buff", this.getDisplayName());
        BukkitTask task = this.taskMap.remove(player);
        if (task != null) {
            task.cancel();
        }
        BuffAPI.removeBuff(player.getUniqueId(), this.getDisplayName());
    }

    protected abstract void buffTimeouted(RaCPlayer var1);
}

