/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.pattern;

import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.traits.magic.AbstractMagicSpellTrait;
import de.tobiyas.racesandclasses.util.entitysearch.SearchEntity;
import de.tobiyas.racesandclasses.util.friend.EnemyChecker;
import de.tobiyas.racesandclasses.util.friend.TargetType;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import org.bukkit.entity.Entity;

public abstract class AbstractActivateAETrait
extends AbstractMagicSpellTrait {
    protected static final String RANGE_PATH = "range";
    protected static final String TARGET_PATH = "target";
    protected double range = 5.0;
    protected TargetType target = TargetType.ALL;

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(classToExpect=Double.class, fieldName="range", optional=true), @TraitConfigurationField(classToExpect=String.class, fieldName="target", optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        if (configMap.containsKey(RANGE_PATH)) {
            this.range = configMap.getAsDouble(RANGE_PATH);
        }
        if (configMap.containsKey(TARGET_PATH)) {
            String target = configMap.getAsString(TARGET_PATH).toLowerCase();
            if (target.startsWith("all")) {
                this.target = TargetType.ALL;
            }
            if (target.startsWith("fr") || target.startsWith("ally")) {
                this.target = TargetType.FRIEND;
            }
            if (target.startsWith("e") || target.startsWith("fe")) {
                this.target = TargetType.ENEMY;
            }
        }
    }

    @Override
    public boolean isBetterThan(Trait trait) {
        return true;
    }

    protected abstract boolean triggerOnEntity(RaCPlayer var1, Entity var2);

    @Override
    protected void magicSpellTriggered(RaCPlayer player, TraitResults result) {
        boolean hitSomething = false;
        for (Entity otherEntity : SearchEntity.inCircleAround((Entity)player.getPlayer(), this.range)) {
            if (!EnemyChecker.isApplyable((Entity)player.getPlayer(), otherEntity, this.target) || !this.triggerOnEntity(player, otherEntity)) continue;
            hitSomething = true;
        }
        result.copyFrom(hitSomething ? TraitResults.True() : TraitResults.False());
    }
}

