/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.pattern;

import de.tobiyas.racesandclasses.APIs.MessageScheduleApi;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.AbstractBasicTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.util.traitutil.TraitRegionChecker;

public abstract class AbstractActivatableTrait
extends AbstractBasicTrait {
    @Override
    public boolean isBindable() {
        return true;
    }

    @Override
    protected final TraitResults bindCastIntern(RaCPlayer player) {
        if (TraitRegionChecker.isInDisabledLocation(player.getLocation())) {
            player.sendTranslatedMessage("disabled_region");
            return TraitResults.False();
        }
        TraitResults result = this.trigger(player);
        this.evaluateTraitResult(player, result);
        return result;
    }

    public abstract TraitResults trigger(RaCPlayer var1);

    @Override
    public TraitResults trigger(EventWrapper wrapper) {
        if (TraitRegionChecker.isInDisabledLocation(wrapper.getPlayer().getLocation())) {
            wrapper.getPlayer().sendTranslatedMessage("disabled_region");
            return TraitResults.False();
        }
        TraitResults result = this.trigger(wrapper.getPlayer());
        this.evaluateIntern(wrapper.getPlayer(), result);
        return result;
    }

    protected void evaluateTraitResult(RaCPlayer player, TraitResults result) {
        if (this.cooldownTime > 0 && result.isTriggered() && result.isSetCooldownOnPositiveTrigger()) {
            this.setCooldownIfNeeded(player);
        }
        this.evaluateIntern(player, result);
    }

    protected void setCooldownIfNeeded(RaCPlayer player) {
        String playerName = player.getName();
        String cooldownName = "trait." + this.getDisplayName();
        int uplinkTraitTime = this.getMaxUplinkTime();
        if (uplinkTraitTime > 0) {
            plugin.getCooldownManager().setCooldown(playerName, cooldownName, uplinkTraitTime);
            MessageScheduleApi.scheduleTranslateMessageToPlayer(player.getName(), uplinkTraitTime, "cooldown_is_ready_again", "trait_name", this.getDisplayName());
        }
    }

    protected void evaluateIntern(RaCPlayer player, TraitResults result) {
    }
}

