/*
 * Decompiled with CFR 0.152.
 */
package de.tobiyas.racesandclasses.traitcontainer.traits.magic;

import de.tobiyas.racesandclasses.APIs.LanguageAPI;
import de.tobiyas.racesandclasses.APIs.SilenceAndKickAPI;
import de.tobiyas.racesandclasses.RacesAndClasses;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapper;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.EventWrapperFactory;
import de.tobiyas.racesandclasses.eventprocessing.eventresolvage.PlayerAction;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayer;
import de.tobiyas.racesandclasses.playermanagement.player.RaCPlayerManager;
import de.tobiyas.racesandclasses.playermanagement.playerdisplay.scoreboard.PlayerRaCScoreboardManager;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.TraitResults;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationField;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitConfigurationNeeded;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.annotations.configuration.TraitEventsUsed;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.CostType;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.MagicSpellTrait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.Trait;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitRestriction;
import de.tobiyas.racesandclasses.traitcontainer.interfaces.markerinterfaces.TraitWithCost;
import de.tobiyas.racesandclasses.traitcontainer.traits.pattern.AbstractActivatableTrait;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfiguration;
import de.tobiyas.racesandclasses.util.traitutil.TraitConfigurationFailedException;
import de.tobiyas.racesandclasses.vollotile.Vollotile;
import de.tobiyas.util.RaC.naming.MCPrettyName;
import de.tobiyas.util.RaC.vollotile.ParticleEffects;
import de.tobiyas.util.RaC.vollotile.helper.ParticleHelper;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class AbstractMagicSpellTrait
extends AbstractActivatableTrait
implements MagicSpellTrait {
    public static final String COST_TYPE_PATH = "costType";
    public static final String COST_PATH = "cost";
    public static final String ITEM_TYPE_PATH = "item";
    public static final String ITEM_DAMAGE_PATH = "itemDamage";
    public static final String ITEM_NAME_PATH = "itemName";
    public static final String CHANNELING_PATH = "channeling";
    private static final Map<String, Long> lastCastMap = new HashMap<String, Long>();
    private static final Map<UUID, ChannelingContainer> channelingMap = new HashMap<UUID, ChannelingContainer>();
    protected double cost = 0.0;
    protected Material materialForCasting = Material.FEATHER;
    protected byte materialDamageForCasting = 0;
    protected String materialNameForCasting = null;
    protected CostType costType = CostType.MANA;
    protected double channelingTime = 0.0;
    protected final RacesAndClasses plugin = RacesAndClasses.getPlugin();
    private int bukkitSchedulerID = -1;

    @Override
    @TraitEventsUsed(registerdClasses={PlayerInteractEvent.class})
    public void generalInit() {
        if (this.channelingTime > 0.0) {
            this.bukkitSchedulerID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Iterator entryIt = channelingMap.entrySet().iterator();
                    while (entryIt.hasNext()) {
                        Map.Entry entry = entryIt.next();
                        RaCPlayer player = RaCPlayerManager.get().getPlayer((UUID)entry.getKey());
                        if (player != null && player.isOnline() && !(player.getLocation().distanceSquared(((ChannelingContainer)entry.getValue()).loc) > 0.5)) continue;
                        entryIt.remove();
                        ((ChannelingContainer)entry.getValue()).task.cancel();
                        RacesAndClasses.getPlugin().getSilenceAndKickManager().endChannel(player.getUniqueId(), AbstractMagicSpellTrait.this);
                        LanguageAPI.sendTranslatedMessage(player, "magic_chaneling_failed", "trait_name", AbstractMagicSpellTrait.this.getDisplayName());
                    }
                }
            }, 10L, 10L);
        }
    }

    @Override
    public void deInit() {
        super.deInit();
        if (this.bukkitSchedulerID > 0) {
            Bukkit.getScheduler().cancelTask(this.bukkitSchedulerID);
            this.bukkitSchedulerID = -1;
        }
    }

    @Override
    public boolean canBeTriggered(EventWrapper wrapper) {
        if (this.canOtherEventBeTriggered(wrapper)) {
            return true;
        }
        if (channelingMap.containsKey(wrapper.getPlayer().getName())) {
            return false;
        }
        PlayerAction action = wrapper.getPlayerAction();
        if (action != PlayerAction.CAST_SPELL && action != PlayerAction.CHANGE_SPELL) {
            return false;
        }
        RaCPlayer player = wrapper.getPlayer();
        boolean playerHasWandInHand = this.checkWandInHand(player);
        if (!playerHasWandInHand) {
            return false;
        }
        return this == player.getSpellManager().getCurrentSpell();
    }

    protected boolean canOtherEventBeTriggered(EventWrapper wrapper) {
        return false;
    }

    @Override
    public boolean triggerButHasUplink(EventWrapper eventWrapper) {
        PlayerAction action = eventWrapper.getPlayerAction();
        if (action != PlayerAction.NONE) {
            boolean playerHasWandInHand = this.checkWandInHand(eventWrapper.getPlayer());
            if (action == PlayerAction.CHANGE_SPELL && playerHasWandInHand) {
                this.changeMagicSpell(eventWrapper.getPlayer());
                return true;
            }
            if (action == PlayerAction.CAST_SPELL) {
                return playerHasWandInHand;
            }
        }
        return true;
    }

    public boolean checkWandInHand(RaCPlayer player) {
        ItemStack holding = player.getPlayer().getInventory().getItem(player.getPlayer().getInventory().getHeldItemSlot());
        return player.getSpellManager().isWandItem(holding);
    }

    @Override
    public void triggerButDoesNotHaveEnoghCostType(EventWrapper wrapper) {
        PlayerAction action = wrapper.getPlayerAction();
        if (action == PlayerAction.CHANGE_SPELL) {
            this.changeMagicSpell(wrapper.getPlayer());
            return;
        }
        String costTypeString = this.getCostType().name();
        if (this.getCostType() == CostType.ITEM) {
            costTypeString = MCPrettyName.getPrettyName(this.getCastMaterialType(wrapper.getPlayer()), (short)0, "en_US");
        }
        LanguageAPI.sendTranslatedMessage(wrapper.getPlayer(), "magic_dont_have_enough", "cost_type", costTypeString, "trait_name", this.getDisplayName());
    }

    @Override
    public TraitResults trigger(EventWrapper eventWrapper) {
        Event event = eventWrapper.getEvent();
        TraitResults result = new TraitResults();
        if (event instanceof PlayerInteractEvent) {
            PlayerInteractEvent playerInteractEvent = (PlayerInteractEvent)event;
            RaCPlayer player = eventWrapper.getPlayer();
            boolean playerHasWandInHand = this.checkWandInHand(player);
            if (!playerHasWandInHand) {
                return result.setTriggered(false);
            }
            if (this != player.getSpellManager().getCurrentSpell()) {
                return result.setTriggered(false);
            }
            Action action = playerInteractEvent.getAction();
            if (action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK) {
                if (lastCastMap.containsKey(player.getUniqueId())) {
                    if (System.currentTimeMillis() - lastCastMap.get(player.getUniqueId()) < 100L) {
                        return result.setTriggered(false);
                    }
                    lastCastMap.remove(player.getUniqueId());
                }
                return this.trigger(player);
            }
            if (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) {
                this.changeMagicSpell(player);
                return result.setTriggered(false);
            }
        }
        return this.otherEventTriggered(eventWrapper, result);
    }

    protected TraitResults otherEventTriggered(EventWrapper eventWrapper, TraitResults result) {
        return result;
    }

    public boolean changeMagicSpell(RaCPlayer player) {
        if (player.getSpellManager().getCurrentSpell() == null) {
            return false;
        }
        if (player.getSpellManager().getSpellAmount() == 0) {
            LanguageAPI.sendTranslatedMessage((CommandSender)player.getPlayer(), "magic_no_spells");
            return true;
        }
        boolean toPrev = player.getPlayer().isSneaking();
        TraitWithCost nextSpell = null;
        nextSpell = toPrev ? player.getSpellManager().changeToPrevSpell() : player.getSpellManager().changeToNextSpell();
        if (nextSpell != null) {
            if (!this.plugin.getConfigManager().getGeneralConfig().isConfig_enable_permanent_scoreboard()) {
                player.getScoreboardManager().updateSelectAndShow(PlayerRaCScoreboardManager.SBCategory.Spells);
            }
            DecimalFormat formatter = new DecimalFormat("###.#");
            String costName = formatter.format(nextSpell.getCost(player));
            String costTypeString = nextSpell.getCostType() == CostType.ITEM ? nextSpell.getCastMaterialType(player).name() : nextSpell.getCostType().name();
            String newSpellName = ((Trait)((Object)nextSpell)).getDisplayName();
            LanguageAPI.sendTranslatedMessage((CommandSender)player.getPlayer(), "magic_change_spells", "trait_name", newSpellName, COST_PATH, costName, "cost_type", costTypeString);
            return true;
        }
        return true;
    }

    protected abstract void magicSpellTriggered(RaCPlayer var1, TraitResults var2);

    @Override
    @TraitConfigurationNeeded(fields={@TraitConfigurationField(fieldName="cost", classToExpect=Double.class, optional=true), @TraitConfigurationField(fieldName="costType", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="item", classToExpect=Material.class, optional=true), @TraitConfigurationField(fieldName="itemDamage", classToExpect=Integer.class, optional=true), @TraitConfigurationField(fieldName="itemName", classToExpect=String.class, optional=true), @TraitConfigurationField(fieldName="channeling", classToExpect=Double.class, optional=true)})
    public void setConfiguration(TraitConfiguration configMap) throws TraitConfigurationFailedException {
        super.setConfiguration(configMap);
        this.cost = configMap.getAsDouble(COST_PATH, 0.0);
        if (configMap.containsKey(COST_TYPE_PATH)) {
            String costTypeName = configMap.getAsString(COST_TYPE_PATH);
            this.costType = CostType.tryParse(costTypeName);
            if (this.costType == null) {
                throw new TraitConfigurationFailedException(String.valueOf(this.getName()) + " is incorrect configured. costType could not be read.");
            }
            if (this.costType == CostType.ITEM) {
                if (!configMap.containsKey(ITEM_TYPE_PATH)) {
                    throw new TraitConfigurationFailedException(String.valueOf(this.getName()) + " is incorrect configured. 'costType' was ITEM but no Item is specified at 'item'.");
                }
                this.materialForCasting = configMap.getAsMaterial(ITEM_TYPE_PATH);
                if (this.materialForCasting == null) {
                    throw new TraitConfigurationFailedException(String.valueOf(this.getName()) + " is incorrect configured." + " 'costType' was ITEM but the item read is not an Item. Items are CAPITAL. " + "See 'https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Material.html' for all Materials. " + "Alternative use an ItemID.");
                }
                this.materialDamageForCasting = (byte)configMap.getAsInt(ITEM_DAMAGE_PATH, 0);
                this.materialNameForCasting = configMap.getAsString(ITEM_NAME_PATH, null);
            }
        }
        this.channelingTime = configMap.getAsDouble(CHANNELING_PATH, 0.0);
    }

    @Override
    public double getCost(RaCPlayer player) {
        int level = player.getLevelManager().getCurrentLevel();
        return this.skillConfig.getCastCostForLevel(level, this.modifyToPlayer(player, this.cost, COST_PATH));
    }

    @Override
    public CostType getCostType() {
        return this.costType;
    }

    @Override
    public Material getCastMaterialType(RaCPlayer player) {
        int level = player.getLevelManager().getCurrentLevel();
        return this.skillConfig.getCastMaterialForLevel(level, this.materialForCasting);
    }

    @Override
    public short getCastMaterialDamage(RaCPlayer player) {
        int level = player.getLevelManager().getCurrentLevel();
        return this.skillConfig.getCastMaterialDamageForLevel(level, this.materialDamageForCasting);
    }

    @Override
    public String getCastMaterialName(RaCPlayer player) {
        int level = player.getLevelManager().getCurrentLevel();
        return this.skillConfig.getCastMaterialNameForLevel(level, this.materialNameForCasting);
    }

    @Override
    public boolean isStackable() {
        return true;
    }

    @Override
    public boolean needsCostCheck(EventWrapper wrapper) {
        return wrapper.getEvent() instanceof PlayerInteractEvent;
    }

    @Override
    public void triggerButHasRestriction(TraitRestriction restriction, EventWrapper wrapper) {
        if (restriction == TraitRestriction.Costs) {
            if (!this.checkWandInHand(wrapper.getPlayer())) {
                return;
            }
            this.triggerButDoesNotHaveEnoghCostType(wrapper);
        } else if (wrapper.getPlayerAction() == PlayerAction.CHANGE_SPELL) {
            this.changeMagicSpell(wrapper.getPlayer());
        }
    }

    @Override
    public boolean isBindable() {
        return true;
    }

    @Override
    public double getChannelingTime() {
        return this.channelingTime;
    }

    @Override
    public TraitResults trigger(final RaCPlayer player) {
        final TraitResults result = TraitResults.False();
        if (this.channelingTime > 0.0) {
            BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (channelingMap.containsKey(player.getUniqueId())) {
                        RacesAndClasses.getPlugin().getSilenceAndKickManager().endChannel(player.getUniqueId(), AbstractMagicSpellTrait.this);
                        if (AbstractMagicSpellTrait.this.checkRestrictions(EventWrapperFactory.buildOnlyWithplayer(player)) != TraitRestriction.None) {
                            return;
                        }
                        AbstractMagicSpellTrait.this.magicSpellTriggered(player, result);
                        if (result.isTriggered() && result.isRemoveCostsAfterTrigger()) {
                            player.getSpellManager().removeCost(AbstractMagicSpellTrait.this);
                        }
                        if (result.isTriggered() && result.isSetCooldownOnPositiveTrigger()) {
                            AbstractMagicSpellTrait.this.setCooldownIfNeeded(player);
                        }
                    }
                }
            }, (long)(this.channelingTime * 20.0));
            RacesAndClasses.getPlugin().getSilenceAndKickManager().startsChannel(player.getUniqueId(), this);
            channelingMap.put(player.getUniqueId(), new ChannelingContainer(player.getLocation(), task));
            result.setTriggered(false);
        } else {
            this.magicSpellTriggered(player, result);
            if (result.isTriggered() && result.isRemoveCostsAfterTrigger()) {
                player.getSpellManager().removeCost(this);
                if (this.onUseParticles != null) {
                    Vollotile.get().sendOwnParticleEffectToAll(this.onUseParticles, player.getLocation().add(0.0, 1.0, 0.0), 0.0f, 10);
                }
            }
        }
        return result;
    }

    @Override
    protected void evaluateIntern(RaCPlayer player, TraitResults result) {
        if (result.isTriggered() && result.isRemoveCostsAfterTrigger()) {
            player.getSpellManager().removeCost(this);
        }
    }

    @Override
    public void gotKicked(UUID player) {
        ChannelingContainer container = channelingMap.remove(player);
        if (container != null && this.isKickable()) {
            container.task.cancel();
            RaCPlayer racPlayer = RaCPlayerManager.get().getPlayer(player);
            if (racPlayer.isOnline()) {
                ParticleHelper.sendXParticleEffectToAllWithRandWidth(ParticleEffects.CRIT, racPlayer.getPlayer().getEyeLocation(), 0.0f, 10);
                racPlayer.sendTranslatedMessage("trait_kicked", "name", this.getName());
            }
        }
    }

    @Override
    public boolean isKickable() {
        return true;
    }

    @Override
    protected TraitRestriction checkForFurtherRestrictions(EventWrapper wrapper) {
        RaCPlayer player = wrapper.getPlayer();
        if (!wrapper.getPlayer().getSpellManager().canCastSpell(this)) {
            return TraitRestriction.Costs;
        }
        if (SilenceAndKickAPI.isSilenced(player.getUniqueId())) {
            return TraitRestriction.Silenced;
        }
        return super.checkForFurtherRestrictions(wrapper);
    }

    protected static class ChannelingContainer {
        final Location loc;
        final BukkitTask task;

        public ChannelingContainer(Location loc, BukkitTask task) {
            this.loc = loc;
            this.task = task;
        }
    }
}

